//
//  ImageCell.m
//  Afficheur
//
//  Created by kichi on 09/03/04.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import "ImageCell.h"


@implementation ImageCell

- (id)init
{
	self = [super init];
	_drawsBackground = NO;
	_backgroundColor = nil;
	return self;
}

- (void)setDrawsBackground:(BOOL)flag
{
	_drawsBackground = flag;
}

- (void)setBackgroundColor:(NSColor *)color
{
	_backgroundColor = color;
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame
					   inView:(NSView *)controlView
{
	if (_drawsBackground && _backgroundColor)
	{
		[_backgroundColor set];
		[NSBezierPath fillRect:NSMakeRect(cellFrame.origin.x - 2,
										  cellFrame.origin.y - 1,
										  cellFrame.size.width + 4,
										  cellFrame.size.height + 1)];
	}
	[super drawInteriorWithFrame:cellFrame
						  inView:controlView];
}

@end
