//
//  OAuth.h
//  Afficheur
//
//  Created by kichi on 09/03/29.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "HTTP.h"


@interface OAuth : HTTP {
	NSString*			_comsumer_key;
	NSString*			_comsumer_secret;
	NSString*			_request_token;
	NSString*			_request_token_secret;
	NSString*			_access_token;
	NSString*			_access_token_secret;
	
	NSString*			_request_token_path;
	NSString*			_access_token_path;
	NSString*			_authorize_path;
}

- (NSString *)stringUrlLower:(NSString *)string;

- (void)setConsumerKey:(NSString *)consumer_key;
- (void)setConsumerSecret:(NSString *)consumer_secret;
- (NSString *)requestToken;
- (NSString *)requestTokenSecret;
- (void)setRequestToken:(NSString *)request_token;
- (void)setRequestTokenSecret:(NSString *)request_token_secret;
- (NSString *)accessToken;
- (NSString *)accessTokenSecret;
- (void)setAccessToken:(NSString *)access_token;
- (void)setAccessTokenSecret:(NSString *)access_token_secret;

- (void)setRequestTokenPath:(NSString *)request_token_path;
- (void)setAccessTokenPath:(NSString *)access_token_path;
- (void)setAuthorizePath:(NSString *)authorize_path;

- (long)nonce:(NSDate *)date;
- (unsigned long)timestamp:(NSDate *)date;
- (NSDictionary *)makeHeaderWithMethod:(NSString *)method
								   url:(NSString *)url
								header:(NSDictionary *)header
								  body:(NSString *)body
						   tokenSecret:(NSString *)tokenSecret;

- (id)request_token;
- (id)access_token;
- (id)access_tokenWithPIN:(NSString *)pin;
- (NSString *)authorizePath;

- (id)postWithOAuth:(NSString *)path
			 header:(NSMutableDictionary *)header
			   body:(NSString *)body;
- (id)getWithOAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body;
- (id)getWithOAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
		  delegate:(id)delegate;
- (id)headWithOAuth:(NSString *)path
			 header:(NSMutableDictionary *)header
			   body:(NSString *)body;

@end
