//
//  Service.h
//  Afficheur
//
//  Created by kichi on 08/09/02.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AfficheurController;
@class AfficheurPreferences;
@class OGRegularExpressionMatch;

@interface Service : NSObject {
	AfficheurController*	_controller;
	AfficheurPreferences*	_preferences;
	NSString*				_service;
	NSImage*				_icon;
	NSString*				_title;
	NSString*				_errorIcon;

	NSThread*				_mainThread;

	BOOL					_state;
	BOOL					_enable;
	BOOL					_changeHeight;

	int						_xmppCount;
//	NSLock*					_lockXMPP;
//	BOOL					_lockedXMPP;
//	NSMutableArray*			_queueXMPP;
	
	NSDictionary*			_DoCoMo;
	NSDictionary*			_EZweb;
	NSDictionary*			_SoftBank;
//	NSDictionary*			_EZwebNowa;
	NSDictionary*			_JaikuIcon;
	NSDictionary*			_JaikuToolTip;
	
	NSMutableDictionary*	_delayedReply;

	NSDictionary*			_unescaping;

	NSImage*				_image;
}

enum {
	kindTimeline = 0,
	kindReply,
	kindDM,
	kindChannel,
};

+ (NSImage *)resizeImage:(NSImage *)image
				withSize:(NSSize)size;

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (NSString *)service;

- (NSString *)toolTipDoCoMo:(unichar)unocode;
- (NSString *)toolTipEZweb:(unichar)unocode;
- (NSString *)toolTipSoftBank:(unichar)unocode;
- (NSString *)toolTipJaiku:(int)iconCode;
- (NSString *)imageNameJaiku:(int)iconCode;

- (void)saveState:(BOOL)state
	   andEnabled:(BOOL)enabled;
- (BOOL)status;
- (BOOL)enable;

- (BOOL)changeHeight;

- (void)determinePost:(NSString *)response
			withTitle:(NSString *)title
			 function:(NSString *)function;
- (void)determinePost:(NSString *)response;

- (BOOL)isReply:(NSDictionary *)object;
- (BOOL)isChannel:(NSDictionary *)object;

- (NSString *)convertText:(NSString *)text;

- (NSDictionary *)fetch:(NSString *)item_id
			withService:(NSString *)service;
- (NSDictionary *)fetchALL:(NSString *)item_id
			   withService:(NSString *)service;
- (NSDictionary *)begins:(NSString *)item_id
			 withService:(NSString *)service
					user:(NSString *)user;

- (int)hasKeyword:(NSString *)text;
- (int)hasKeywords:(NSArray *)texts;

- (NSString *)stringFromHexString:(NSString *)str;

- (NSString *)stringFromEmoji:(NSString *)str;
//- (NSString *)stringFromEmojiNowa:(NSString *)str;

- (NSAttributedString *)attributedString:(id)text
								withSize:(float)size
								baseLine:(float)baseLine
									attr:(NSDictionary *)attr;

- (NSAttributedString *)replyAttributedString:(NSString *)text;

- (void)registComplete:(NSString *)text
		  flagIdentica:(BOOL)flagIdentica;
- (void)registComplete:(NSString *)text;
- (void)registCompleteIdentica:(NSString *)text;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 keyword:(int)keyword
					 protect:(BOOL)protect
					verified:(BOOL)verified
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 protect:(BOOL)protect
					verified:(BOOL)verified
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 protect:(BOOL)protect
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 keyword:(int)keyword
					 protect:(BOOL)protect
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 protect:(BOOL)protect
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 keyword:(int)keyword
					 protect:(BOOL)protect
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					   first:(BOOL)first
					   xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 protect:(BOOL)protect
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					text_raw:(NSString *)text_raw
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 keyword:(int)keyword
					 protect:(BOOL)protect
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 keyword:(int)keyword
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					   first:(BOOL)first
						xmpp:(BOOL)xmpp;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 keyword:(int)keyword
					 protect:(BOOL)protect
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 protect:(BOOL)protect
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 keyword:(int)keyword
					 protect:(BOOL)protect
					verified:(BOOL)verified
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
				 retweetedBy:(NSString *)retweetedBy
				 retweetedId:(NSString *)retweetedId
					 protect:(BOOL)protect
					verified:(BOOL)verified
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 protect:(BOOL)protect
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				  created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					 keyword:(int)keyword
					   first:(BOOL)first;

- (NSDictionary *)createItem:(NSString *)item_id
					withUser:(NSString *)user
						name:(NSString *)name
					 channel:(NSString *)channel
						 rid:(NSString *)rid
						text:(NSString *)text
					 comment:(NSString *)comment
					  source:(NSString *)source
				   created_at:(NSDate *)created_at
				user_profile:(NSString *)user_profile
					  notify:(NSString *)notify
						kind:(NSString *)kind
					category:(NSString *)category
				 inReplyUser:(NSString *)inReplyUser
					   first:(BOOL)first;

- (NSString*)extractShortenURL:(OGRegularExpressionMatch*)aMatch
				   contextInfo:(id)contextInfo;

- (NSDictionary *)parsePhotoURL:(NSDictionary *)item;

- (id)getWithAuth:(NSString *)url;

- (void)lockService;
- (void)unlockService;

- (BOOL)isDelayedReply:(NSString *)item_id;
- (void)setDelayedReply:(NSString *)item_id;
- (void)removeDelayedReply:(NSString *)item_id;

- (BOOL)addTimeline:(NSDictionary *)item
		  withFirst:(BOOL)first;
- (void)finishAddTimeline:(NSArray *)list
			   withNotify:(NSArray *)notify;

- (BOOL)deleteTimeline:(NSString *)item_id
		   withService:(NSString *)service;

- (void)doOpenURL:(NSString *)url;
- (void)openURL:(NSString *)item_id;

- (void)doReply:(NSString *)item_id
	   withText:(BOOL)withText;
- (void)doReply:(NSString *)item_id;
- (void)doRetweetViaAPI:(NSString *)item_id;
- (void)doDirectMessage:(NSString *)item_id;

//- (void)lockXMPP;
//- (void)unlockXMPP;

@end

APPKIT_EXTERN NSString *IdZero;

APPKIT_EXTERN NSString *KeyService;
APPKIT_EXTERN NSString *KeyServiceIcon;
APPKIT_EXTERN NSString *KeyId;
APPKIT_EXTERN NSString *KeyRId;
APPKIT_EXTERN NSString *KeyChannel;
APPKIT_EXTERN NSString *KeyUser;
APPKIT_EXTERN NSString *KeyName;
APPKIT_EXTERN NSString *KeyTextRaw;
APPKIT_EXTERN NSString *KeyText;
APPKIT_EXTERN NSString *KeyTextEx;
APPKIT_EXTERN NSString *KeyComment;
APPKIT_EXTERN NSString *KeySource;
APPKIT_EXTERN NSString *KeySourceIcon;
APPKIT_EXTERN NSString *KeySourceIconImage;
APPKIT_EXTERN NSString *KeyPhotoURL;
APPKIT_EXTERN NSString *KeyImageURL;
APPKIT_EXTERN NSString *KeyImage;
APPKIT_EXTERN NSString *KeyIcon;
APPKIT_EXTERN NSString *KeyIconImage;
APPKIT_EXTERN NSString *KeyTextDisplay;
APPKIT_EXTERN NSString *KeyTextDisplaySelected;
APPKIT_EXTERN NSString *KeyTextNotify;
APPKIT_EXTERN NSString *KeyCreatedAt;
APPKIT_EXTERN NSString *KeyUserProfile;
APPKIT_EXTERN NSString *KeyProfileImage;
APPKIT_EXTERN NSString *KeyNotifyTitle;
APPKIT_EXTERN NSString *KeyNotify;
APPKIT_EXTERN NSString *KeyDate;
APPKIT_EXTERN NSString *KeyDateDisplay;
APPKIT_EXTERN NSString *KeyDateDisplaySelected;
APPKIT_EXTERN NSString *KeyKind;
APPKIT_EXTERN NSString *KeyCategory;
APPKIT_EXTERN NSString *KeyFirst;
APPKIT_EXTERN NSString *KeyIndex;
APPKIT_EXTERN NSString *KeyWidth;
APPKIT_EXTERN NSString *KeyHeight;
APPKIT_EXTERN NSString *KeyInReplyUser;
APPKIT_EXTERN NSString *KeyRetweetedBy;
APPKIT_EXTERN NSString *KeyRetweetedId;
APPKIT_EXTERN NSString *KeyKeyword;
APPKIT_EXTERN NSString *KeyProtected;
APPKIT_EXTERN NSString *KeyFrom;
APPKIT_EXTERN NSString *KeySort;
APPKIT_EXTERN NSString *KeyVerified;
APPKIT_EXTERN NSString *KeyFbName;
APPKIT_EXTERN NSString *KeyFbCaption;
APPKIT_EXTERN NSString *KeyFbDescription;
APPKIT_EXTERN NSString *KeyFbLink;

APPKIT_EXTERN NSString *KindTimeline;
APPKIT_EXTERN NSString *KindReply;
APPKIT_EXTERN NSString *KindDM;
APPKIT_EXTERN NSString *KindChannel;
APPKIT_EXTERN NSString *KindError;

APPKIT_EXTERN NSString *FromAPI;
APPKIT_EXTERN NSString *FromXMPP;

APPKIT_EXTERN NSString *Twitter;
APPKIT_EXTERN NSString *Jaiku;
APPKIT_EXTERN NSString *Tumblr;
//APPKIT_EXTERN NSString *Nowa;
APPKIT_EXTERN NSString *Wassr;
APPKIT_EXTERN NSString *Identica;
//APPKIT_EXTERN NSString *Jisko;
//APPKIT_EXTERN NSString *Chuitter;
APPKIT_EXTERN NSString *FriendFeed;
APPKIT_EXTERN NSString *FaceBook;

APPKIT_EXTERN NSString *ProfilePhoto;
APPKIT_EXTERN NSString *ProfileIcon;
APPKIT_EXTERN NSString *ProfileSource;
