//
//  ServiceFaceBook.h
//  Afficheur
//
//  Created by kichi on 11/01/02.
//  Copyright 2011 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Service.h"
#import "FaceBookAPI.h"

@class ServiceXMPP;

@interface ServiceFaceBook : Service {
	NSString*				_notify;
	NSString*				_notifyComment;
	NSString*				_notifyGroup;
	NSString*				_notifyReply;
	NSString*				_notifyError;
	
	NSMutableDictionary*	_userProfile;
	NSDate*					_dateTimeline;
	
	BOOL					_first;
	
	NSString*				_user_id;
	NSString*				_user_name;
	NSString*				_access_token;
}

enum {
	kindMessage = 0,
	kindLink,
};

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP:(ServiceXMPP *)xmpp;

- (NSString *)userId;
- (NSString *)userName;
- (NSString *)accessToken;

- (NSString *)authorize;
- (BOOL)access_token:(NSString *)param;

- (BOOL)me;

- (void)setupRetrieveDate:(NSDate *)date;
- (void)setupRetrieveDateTimeline:(NSDate *)date;

- (BOOL)checkRetrieveTimeline:(NSDate *)date;

- (void)post:(NSString *)status
   withReply:(NSString *)reply;

- (void)retrieveHomeFeed;

- (void)favorite:(NSString *)item_id;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

@end
