//
//  ServiceIdentica.h
//  Afficheur
//
//  Created by kichi on 08/10/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ServiceTwitter.h"

@class ServiceXMPP;

@interface ServiceIdentica : ServiceTwitter {
	NSString*			_notifyGroup;

}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP:(ServiceXMPP *)xmpp;

- (BOOL)checkRetrieveTimeline:(NSDate *)now;
- (BOOL)checkRetrieveReplies:(NSDate *)now;
- (BOOL)checkRetrieveDM:(NSDate *)now;

- (NSDictionary *)apiParam;

- (void)post:(NSString *)status
   withReply:(NSString *)reply;

- (NSDictionary *)parse:(NSDictionary *)obj
			   withUser:(NSString *)user_id
				   kind:(int)kind
				  first:(BOOL)first;

- (void)retrieveTimeline;
- (void)retrieveReplies;
- (void)retrieveDirectMessage;

- (void)favorite:(NSString *)item_id;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

@end
