//
//  ServiceJaiku.h
//  Afficheur
//
//  Created by kichi on 08/09/02.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Service.h"
#import "JaikuAPI.h"

@class ServiceXMPP;

@interface ServiceJaiku : Service {
	NSString*				_notify;
	NSString*				_notifyComment;
	NSString*				_notifyReply;
	NSString*				_notifyError;

	NSMutableDictionary*	_userProfile;
	NSDate*					_dateTimeline;

	BOOL					_first;

	NSString*				_request_token;
	NSString*				_request_token_secret;
	NSString*				_access_token;
	NSString*				_access_token_secret;
}

enum {
	kindContacts = 0,
	kindPresence,
};

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP:(ServiceXMPP *)xmpp;

- (NSString *)authorize;
- (BOOL)access_token;
- (NSString *)accessToken;
- (NSString *)accessTokenSecret;

- (void)setupRetrieveDate:(NSDate *)date;
- (void)setupRetrieveDateTimeline:(NSDate *)date;

- (BOOL)checkRetrieveTimeline:(NSDate *)date;

- (void)post:(NSString *)status
	withIcon:(int)iconCode;
- (void)comment:(NSString *)comment
	   withItem:(NSString *)item_id;

- (void)retrieveContactsFeed;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

@end
