/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.PageBtreeIndex;
import org.h2.result.ResultExternal;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.value.Value;
import org.h2.value.ValueArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private Session session;
    private RegularTable table;
    private SortOrder sort;
    private Index index;
    private Cursor resultCursor;

    public ResultTempTable(Session session, SortOrder sortOrder) {
        this.session = session;
        this.sort = sortOrder;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        Column column = new Column(COLUMN_NAME, 17);
        column.setNullable(false);
        CreateTableData createTableData = new CreateTableData();
        createTableData.columns.add(column);
        createTableData.id = session.getDatabase().allocateObjectId();
        createTableData.tableName = "TEMP_RESULT_SET_" + createTableData.id;
        createTableData.temporary = true;
        createTableData.persistIndexes = false;
        createTableData.persistData = true;
        createTableData.create = true;
        createTableData.session = session;
        this.table = (RegularTable)schema.createTable(createTableData);
        int n = session.getDatabase().allocateObjectId();
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.column = column;
        indexColumn.columnName = COLUMN_NAME;
        IndexType indexType = IndexType.createPrimaryKey(true, false);
        IndexColumn[] indexColumnArray = new IndexColumn[]{indexColumn};
        this.index = new PageBtreeIndex(this.table, n, createTableData.tableName, indexColumnArray, indexType, true, session);
        this.index.setTemporary(true);
        this.table.getIndexes().add(this.index);
    }

    @Override
    public int removeRow(Value[] valueArray) {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    @Override
    public boolean contains(Value[] valueArray) {
        return this.find(this.convertToRow(valueArray)) != null;
    }

    @Override
    public int addRow(Value[] valueArray) {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor == null) {
            this.table.addRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    @Override
    public void addRows(ArrayList<Value[]> arrayList) {
        if (this.sort != null) {
            this.sort.sort(arrayList);
        }
        for (Value[] valueArray : arrayList) {
            this.addRow(valueArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.table == null) {
            return;
        }
        try {
            Database database;
            this.table.truncate(this.session);
            Database database2 = database = this.session.getDatabase();
            synchronized (database2) {
                Session session = database.getSystemSession();
                if (!database.isSysTableLocked()) {
                    Session session2 = session;
                    synchronized (session2) {
                        this.index.removeChildrenAndResources(session);
                        this.table.removeChildrenAndResources(session);
                        session.commit(false);
                    }
                }
            }
        }
        finally {
            this.table = null;
        }
    }

    @Override
    public void done() {
    }

    @Override
    public Value[] next() {
        if (!this.resultCursor.next()) {
            return null;
        }
        Row row = this.resultCursor.get();
        ValueArray valueArray = (ValueArray)row.getValue(0);
        return valueArray.getList();
    }

    @Override
    public void reset() {
        this.resultCursor = this.index.find(this.session, null, null);
    }

    private Row convertToRow(Value[] valueArray) {
        ValueArray valueArray2 = ValueArray.get(valueArray);
        return new Row(new Value[]{valueArray2}, -1);
    }

    private Cursor find(Row row) {
        Cursor cursor = this.index.find(this.session, row, row);
        Value value = row.getValue(0);
        while (cursor.next()) {
            SearchRow searchRow = cursor.getSearchRow();
            Value value2 = searchRow.getValue(0);
            if (!this.session.getDatabase().areEqual(value, value2)) continue;
            return cursor;
        }
        return null;
    }
}

