/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.liftweb.common.Box;
import net.liftweb.common.Empty$;
import net.liftweb.common.Failure;
import net.liftweb.common.Full;
import net.liftweb.common.Logger;
import net.liftweb.common.Logger$;
import net.liftweb.util.ControlHelpers;
import net.liftweb.util.TimeHelpers;
import net.liftweb.util.TimeHelpers$;
import net.liftweb.util.TimeHelpers$TimeSpan$;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class TimeHelpers$class {
    public static final Logger net$liftweb$util$TimeHelpers$$logger(TimeHelpers $this) {
        return Logger$.MODULE$.apply(TimeHelpers.class);
    }

    public static TimeHelpers.TimeSpanBuilder longToTimeSpanBuilder(TimeHelpers $this, long in) {
        return new TimeHelpers.TimeSpanBuilder($this, in);
    }

    public static TimeHelpers.TimeSpanBuilder intToTimeSpanBuilder(TimeHelpers $this, int in) {
        return new TimeHelpers.TimeSpanBuilder($this, in);
    }

    public static TimeHelpers.TimeSpan longToTimeSpan(TimeHelpers $this, long in) {
        TimeHelpers$TimeSpan$ timeHelpers$TimeSpan$ = $this.TimeSpan();
        return new TimeHelpers.TimeSpan(timeHelpers$TimeSpan$.$outer, in);
    }

    public static TimeHelpers.TimeSpan intToTimeSpan(TimeHelpers $this, int in) {
        long l = in;
        TimeHelpers$TimeSpan$ timeHelpers$TimeSpan$ = $this.TimeSpan();
        return new TimeHelpers.TimeSpan(timeHelpers$TimeSpan$.$outer, l);
    }

    public static final Period net$liftweb$util$TimeHelpers$$durToPeriod(TimeHelpers $this, Duration dur) {
        return dur.toPeriod(PeriodType.standard());
    }

    public static long nano(TimeHelpers $this) {
        return System.nanoTime();
    }

    public static long millis(TimeHelpers $this) {
        return System.currentTimeMillis();
    }

    public static long seconds(TimeHelpers $this, long in) {
        return in * 1000L;
    }

    public static long minutes(TimeHelpers $this, long in) {
        return $this.seconds(in) * 60L;
    }

    public static long hours(TimeHelpers $this, long in) {
        return $this.minutes(in) * 60L;
    }

    public static long days(TimeHelpers $this, long in) {
        return $this.hours(in) * 24L;
    }

    public static long weeks(TimeHelpers $this, long in) {
        return $this.days(in) * 7L;
    }

    public static TimeHelpers.DateExtension toDateExtension(TimeHelpers $this, Date d) {
        return $this.new TimeHelpers.DateExtension(d);
    }

    public static TimeHelpers.CalendarExtension toCalendarExtension(TimeHelpers $this, Calendar c) {
        return new TimeHelpers.CalendarExtension($this, c);
    }

    public static Date now(TimeHelpers $this) {
        return new Date();
    }

    public static Calendar today(TimeHelpers $this) {
        return $this.toCalendarExtension(Calendar.getInstance()).noTime();
    }

    public static int currentYear(TimeHelpers $this) {
        return Calendar.getInstance().get(1);
    }

    public static Date timeNow(TimeHelpers $this) {
        return new Date();
    }

    public static Date dayNow(TimeHelpers $this) {
        return $this.intToTimeSpanBuilder(0).seconds().later().noTime();
    }

    public static Date time(TimeHelpers $this, long when) {
        return new Date(when);
    }

    public static int month(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(2);
    }

    public static int year(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(1);
    }

    public static int day(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(5);
    }

    public static long millisToDays(TimeHelpers $this, long millis) {
        return millis / 86400000L;
    }

    public static long daysSinceEpoch(TimeHelpers $this) {
        return $this.millisToDays($this.millis());
    }

    public static Tuple2 calcTime(TimeHelpers $this, Function0 f) {
        long start = $this.millis();
        Object result = f.apply();
        long l = $this.millis() - start;
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)l), result);
    }

    public static Object logTime(TimeHelpers $this, String msg$1, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        long time$1 = tuple22._1$mcL$sp();
        Object ret = tuple22._2();
        $this.net$liftweb$util$TimeHelpers$$logger().info((Function0)new TimeHelpers$.anonfun.logTime.1($this, msg$1, time$1));
        return ret;
    }

    public static Object logTime(TimeHelpers $this, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        long time$2 = tuple22._1$mcL$sp();
        Tuple2 fret = (Tuple2)tuple22._2();
        if (fret == null) {
            throw new MatchError((Object)fret);
        }
        Tuple2 tuple23 = new Tuple2(fret._1(), fret._2());
        String msg$2 = (String)tuple23._1();
        Object ret = tuple23._2();
        $this.net$liftweb$util$TimeHelpers$$logger().info((Function0)new TimeHelpers$.anonfun.logTime.2($this, time$2, msg$2));
        return ret;
    }

    public static SimpleDateFormat hourFormat(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static String hourFormat(TimeHelpers $this, Date in) {
        return $this.hourFormat().format(in);
    }

    public static SimpleDateFormat dateFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static SimpleDateFormat timeFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm zzz");
    }

    public static String formattedDateNow(TimeHelpers $this) {
        return $this.dateFormatter().format($this.now());
    }

    public static String formattedTimeNow(TimeHelpers $this) {
        return $this.timeFormatter().format($this.now());
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleDateFormat internetDateFormatter(TimeHelpers $this) {
        void var1_1;
        SimpleDateFormat ret = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        ret.setTimeZone($this.utc());
        return var1_1;
    }

    public static Box boxParseInternetDate(TimeHelpers $this, String dateString$1) {
        return ((ControlHelpers)((Object)$this)).tryo(new TimeHelpers$.anonfun.boxParseInternetDate.1($this, dateString$1));
    }

    public static Date parseInternetDate(TimeHelpers $this, String dateString$2) {
        return (Date)((ControlHelpers)((Object)$this)).tryo(new TimeHelpers$.anonfun.parseInternetDate.1($this, dateString$2)).openOr((Function0)new TimeHelpers$.anonfun.parseInternetDate.2($this));
    }

    public static String toInternetDate(TimeHelpers $this, Date in) {
        return $this.internetDateFormatter().format(in);
    }

    public static String toInternetDate(TimeHelpers $this, long in) {
        return $this.internetDateFormatter().format(new Date(in));
    }

    public static String nowAsInternetDate(TimeHelpers $this) {
        return $this.toInternetDate($this.millis());
    }

    /*
     * Unable to fully structure code
     */
    public static Box toDate(TimeHelpers $this, Object in$1) {
        try {
            block13: {
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                if (in$1 != null) break block12;
                                v0 = Empty$.MODULE$;
                                break block13;
                            }
                            if (!(in$1 instanceof Date)) break block14;
                            v0 = new Full((Object)((Date)in$1));
                            break block13;
                        }
                        if (!(in$1 instanceof Long)) break block15;
                        v0 = new Full((Object)new Date(BoxesRunTime.unboxToLong((Object)in$1)));
                        break block13;
                    }
                    if (!(in$1 instanceof Number)) break block16;
                    v0 = new Full((Object)new Date(((Number)in$1).longValue()));
                    break block13;
                }
                v1 = Nil$.MODULE$;
                if (!(v1 == null ? in$1 != null : v1.equals(in$1) == false)) ** GOTO lbl-1000
                v2 = Empty$.MODULE$;
                if (!(v2 == null ? in$1 != null : v2.equals(in$1) == false)) ** GOTO lbl-1000
                v3 = None$.MODULE$;
                if (!(v3 == null ? in$1 != null : v3.equals(in$1) == false) || in$1 instanceof Failure) lbl-1000:
                // 3 sources

                {
                    v0 = Empty$.MODULE$;
                } else if (in$1 instanceof Full) {
                    v0 = $this.toDate(((Full)in$1).value());
                } else if (in$1 instanceof Some) {
                    v0 = $this.toDate(((Some)in$1).x());
                } else if (in$1 instanceof .colon.colon) {
                    v0 = $this.toDate(((.colon.colon)in$1).hd$1());
                } else if (in$1 instanceof String) {
                    var2_2 = (String)in$1;
                    v0 = ((ControlHelpers)$this).tryo(new TimeHelpers$.anonfun.toDate.1($this, var2_2)).or((Function0)new TimeHelpers$.anonfun.toDate.2($this, var2_2));
                } else {
                    v0 = $this.toDate(in$1.toString());
                }
            }
            exceptionResult1 = v0;
        }
        catch (Throwable var3_4) {
            $this.net$liftweb$util$TimeHelpers$$logger().debug((Function0)new TimeHelpers$.anonfun.toDate.3($this, in$1), var3_4);
            exceptionResult1 = new Failure(new StringBuilder().append((Object)"Bad date: ").append(in$1).toString(), (Box)new Full((Object)var3_4), (Box)Empty$.MODULE$);
        }
        return exceptionResult1;
    }

    public static void $init$(TimeHelpers $this) {
        $this.net$liftweb$util$TimeHelpers$_setter_$net$liftweb$util$TimeHelpers$$outer_$eq($this);
        $this.net$liftweb$util$TimeHelpers$_setter_$utc_$eq(TimeZone.getTimeZone("UTC"));
    }
}

