/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;

public class CommandList
extends Command {
    private final Command command;
    private final String remaining;

    public CommandList(Parser parser, String sql, Command c, String remaining) {
        super(parser, sql);
        this.command = c;
        this.remaining = remaining;
    }

    public ObjectArray getParameters() {
        return this.command.getParameters();
    }

    private void executeRemaining() throws SQLException {
        Command command = this.session.prepareLocal(this.remaining);
        if (command.isQuery()) {
            command.query(0);
        } else {
            command.update();
        }
    }

    public int update() throws SQLException {
        int updateCount = this.command.executeUpdate();
        this.executeRemaining();
        return updateCount;
    }

    public LocalResult query(int maxrows) throws SQLException {
        LocalResult result = this.command.query(maxrows);
        this.executeRemaining();
        return result;
    }

    public boolean isQuery() {
        return this.command.isQuery();
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public LocalResult queryMeta() throws SQLException {
        return this.command.queryMeta();
    }
}

