/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.SoftReference;
import org.h2.constant.SysProperties;

public class StringCache {
    private static final boolean ENABLED = true;
    private static SoftReference softCache = new SoftReference<Object>(null);

    public static String get(String s) {
        int index;
        String cached;
        if (!SysProperties.OBJECT_CACHE) {
            return s;
        }
        if (s == null) {
            return s;
        }
        if (s.length() == 0) {
            return "";
        }
        String[] cache = (String[])softCache.get();
        int hash = s.hashCode();
        if (cache == null) {
            cache = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(cache);
        }
        if ((cached = cache[index = hash & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && s.equals(cached)) {
            return cached;
        }
        cache[index] = s;
        return s;
    }

    public static String getNew(String s) {
        int index;
        String cached;
        if (!SysProperties.OBJECT_CACHE) {
            return s;
        }
        if (s == null) {
            return s;
        }
        if (s.length() == 0) {
            return "";
        }
        String[] cache = (String[])softCache.get();
        int hash = s.hashCode();
        if (cache == null) {
            cache = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(cache);
        }
        if ((cached = cache[index = hash & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && s.equals(cached)) {
            return cached;
        }
        cache[index] = s = new String(s);
        return s;
    }

    public static void clearCache() {
        softCache = new SoftReference<Object>(null);
    }
}

