/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.FileUtils;

public class TempFileDeleter {
    private static final ReferenceQueue QUEUE = new ReferenceQueue();
    private static final HashMap REF_MAP = new HashMap();

    public static synchronized Reference addFile(String fileName, Object file) {
        FileUtils.trace("TempFileDeleter.addFile", fileName, file);
        PhantomReference<Object> ref = new PhantomReference<Object>(file, QUEUE);
        TempFile f = new TempFile();
        f.fileName = fileName;
        f.lastModified = FileUtils.getLastModified(fileName);
        REF_MAP.put(ref, f);
        TempFileDeleter.deleteUnused();
        return ref;
    }

    public static synchronized void deleteFile(Reference ref, String fileName) {
        TempFile f2;
        if (ref != null && (f2 = (TempFile)REF_MAP.remove(ref)) != null) {
            if (SysProperties.CHECK && fileName != null && !f2.fileName.equals(fileName)) {
                throw Message.getInternalError("f2:" + f2.fileName + " f:" + fileName);
            }
            fileName = f2.fileName;
            long mod = FileUtils.getLastModified(fileName);
            if (mod != f2.lastModified) {
                return;
            }
        }
        if (fileName != null && FileUtils.exists(fileName)) {
            try {
                FileUtils.trace("TempFileDeleter.deleteFile", fileName, null);
                FileUtils.tryDelete(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteUnused() {
        Reference ref;
        while (QUEUE != null && (ref = QUEUE.poll()) != null) {
            TempFileDeleter.deleteFile(ref, null);
        }
    }

    public static void stopAutoDelete(Reference ref, String fileName) {
        FileUtils.trace("TempFileDeleter.stopAutoDelete", fileName, ref);
        if (ref != null) {
            TempFile f2 = (TempFile)REF_MAP.remove(ref);
            if (SysProperties.CHECK && (f2 == null || !f2.fileName.equals(fileName))) {
                throw Message.getInternalError("f2:" + f2 + " " + (f2 == null ? "" : f2.fileName) + " f:" + fileName);
            }
        }
        TempFileDeleter.deleteUnused();
    }

    private static class TempFile {
        String fileName;
        long lastModified;

        private TempFile() {
        }
    }
}

