/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Method;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.IMocksControl;
import org.easymock.classextension.internal.ClassExtensionHelper;
import org.easymock.classextension.internal.ClassProxyFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.MocksControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MocksClassControl
extends MocksControl
implements IMocksControl {
    public MocksClassControl(MocksControl.MockType type) {
        super(type);
    }

    @Override
    public <T> T createMock(String name, Class<T> toMock, Method ... mockedMethods) {
        if (toMock.isInterface()) {
            throw new IllegalArgumentException("Partial mocking doesn't make sense for interface");
        }
        Object mock = this.createMock(name, toMock);
        ClassExtensionHelper.getInterceptor(mock).setMockedMethods(mockedMethods);
        return (T)mock;
    }

    @Override
    public <T> T createMock(Class<T> toMock, Method ... mockedMethods) {
        if (toMock.isInterface()) {
            throw new IllegalArgumentException("Partial mocking doesn't make sense for interface");
        }
        Object mock = this.createMock(toMock);
        ClassExtensionHelper.getInterceptor(mock).setMockedMethods(mockedMethods);
        return (T)mock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        ClassExtensionHelper.setCurrentConstructorArgs(constructorArgs);
        try {
            T t = this.createMock(toMock, mockedMethods);
            return t;
        }
        finally {
            ClassExtensionHelper.setCurrentConstructorArgs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        ClassExtensionHelper.setCurrentConstructorArgs(constructorArgs);
        try {
            T t = this.createMock(name, toMock, mockedMethods);
            return t;
        }
        finally {
            ClassExtensionHelper.setCurrentConstructorArgs(null);
        }
    }

    protected <T> IProxyFactory<T> createProxyFactory(Class<T> toMock) {
        if (toMock.isInterface()) {
            return super.createProxyFactory(toMock);
        }
        return new ClassProxyFactory();
    }
}

