/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.util.FileUtils;
import org.h2.util.Tool;

public class ChangePassword
extends Tool {
    private String dir;
    private String cipher;
    private byte[] decrypt;
    private byte[] encrypt;

    private void showUsage() {
        this.out.println("Allows changing the database file password.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -cipher <type>    AES or XTEA\n" + " [-dir <dir>]      The database directory (default: .)\n" + " [-db <database>]  The database name (default: all databases)\n" + " [-decrypt <pwd>]  The decryption password (default: the database is not yet encrypted)\n" + " [-encrypt <pwd>]  The encryption password (default: the database should not be encrypted)\n" + " [-quiet]          Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new ChangePassword().run(args);
    }

    public void run(String[] args) throws SQLException {
        String dir = ".";
        String cipher = null;
        char[] decryptPassword = null;
        char[] encryptPassword = null;
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-cipher")) {
                cipher = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-decrypt")) {
                decryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-encrypt")) {
                encryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        if (encryptPassword == null && decryptPassword == null || cipher == null) {
            this.showUsage();
            return;
        }
        this.process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
    }

    private static byte[] getFileEncryptionKey(char[] password) {
        if (password == null) {
            return null;
        }
        SHA256 sha = new SHA256();
        return sha.getKeyPasswordHash("file", password);
    }

    public static void execute(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        new ChangePassword().process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
    }

    private void process(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        String fileName;
        int i;
        ChangePassword change = new ChangePassword();
        if (encryptPassword != null) {
            for (int i2 = 0; i2 < encryptPassword.length; ++i2) {
                if (encryptPassword[i2] != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
        }
        change.out = this.out;
        change.dir = dir;
        change.cipher = cipher;
        change.decrypt = ChangePassword.getFileEncryptionKey(decryptPassword);
        change.encrypt = ChangePassword.getFileEncryptionKey(encryptPassword);
        ArrayList files = FileLister.getDatabaseFiles(dir, db, false);
        for (i = 0; i < files.size(); ++i) {
            fileName = (String)files.get(i);
            String temp = dir + "/temp.db";
            FileUtils.delete(temp);
            FileUtils.rename(fileName, temp);
            FileUtils.rename(temp, fileName);
        }
        for (i = 0; i < files.size(); ++i) {
            fileName = (String)files.get(i);
            change.process(fileName);
        }
        if (files.size() == 0 && !quiet) {
            this.out.println("No database files found");
        }
    }

    private void process(String fileName) throws SQLException {
        boolean textStorage = Database.isTextStorage(fileName, false);
        byte[] magic = Database.getMagic(textStorage);
        FileStore in = this.decrypt == null ? FileStore.open(null, fileName, "r", magic) : FileStore.open(null, fileName, "r", magic, this.cipher, this.decrypt);
        in.init();
        this.copy(fileName, textStorage, in, this.encrypt);
    }

    private void copy(String fileName, boolean textStorage, FileStore in, byte[] key) throws SQLException {
        long remaining;
        String temp = this.dir + "/temp.db";
        FileUtils.delete(temp);
        byte[] magic = Database.getMagic(textStorage);
        FileStore fileOut = key == null ? FileStore.open(null, temp, "rw", magic) : FileStore.open(null, temp, "rw", magic, this.cipher, key);
        fileOut.init();
        byte[] buffer = new byte[4096];
        long total = remaining = in.length() - 48L;
        in.seek(48L);
        fileOut.seek(48L);
        long time = System.currentTimeMillis();
        while (remaining > 0L) {
            if (System.currentTimeMillis() - time > 1000L) {
                this.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                time = System.currentTimeMillis();
            }
            int len = (int)Math.min((long)buffer.length, remaining);
            in.readFully(buffer, 0, len);
            fileOut.write(buffer, 0, len);
            remaining -= (long)len;
        }
        try {
            in.close();
            fileOut.close();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
        FileUtils.delete(fileName);
        FileUtils.rename(temp, fileName);
    }
}

