package jp.sf.amateras.mirage.session;

import java.sql.Connection;
import java.sql.DriverManager;

import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;

public class JDBCSessionImpl implements Session {

	private SqlManager sqlManager;
	private DefaultConnectionProvider provider;
	private String driver;
	private String url;
	private String user;
	private String password;

	public JDBCSessionImpl(String driver, String url, String user, String password){
		this.driver = driver;
		this.url = url;
		this.user = user;
		this.password = password;

		sqlManager = new SqlManagerImpl();
		provider = new DefaultConnectionProvider();
		sqlManager.setConnectionProvider(provider);
	}

	@Override
	public void begin() throws Exception {
		Class.forName(driver);
		Connection conn = DriverManager.getConnection(url, user, password);
		conn.setAutoCommit(false);
		provider.setConnection(conn);
	}

	@Override
	public void commit() throws Exception {
		provider.getConnection().commit();
	}

	@Override
	public SqlManager getSqlManager() {
		return sqlManager;
	}

	@Override
	public void release() throws Exception {
		if(provider instanceof DefaultConnectionProvider){
			((DefaultConnectionProvider) provider).releaseConnection();
		}
	}

	@Override
	public void rollback() throws Exception {
		provider.getConnection().rollback();
	}

}
