package jp.sf.amateras.rdiffbackup.service;

import java.util.List;

import javax.annotation.Resource;

import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.rdiffbackup.entity.BackupDir;

/**
 * 設定関係のデータベースアクセスをラップするサービスクラスです。
 *
 * @author Naoki Takezoe
 */
public class ConfigService {

	@Resource
	protected SqlManager sqlManager;

	/**
	 * バックアップディレクトリ情報のリストを返却します。
	 *
	 * @return バックアップディレクトリ情報のリスト
	 */
	public List<BackupDir> getBackupDirList(){
		return sqlManager.getResultListBySql(
				BackupDir.class, "SELECT * FROM BACKUP_DIRS ORDER BY ID");
	}

	/**
	 * バックアップディレクトリを取得します。
	 *
	 * @param id バックアップディレクトリのID
	 * @return バックアップディレクトリの情報
	 */
	public BackupDir getBackupDir(Long id){
		return sqlManager.findEntity(BackupDir.class, id);
	}

	/**
	 * バックアップディレクトリを追加します。
	 *
	 * @param directory バックアップディレクトリのルートディレクトリ
	 * @param description バックアップディレクトリの説明
	 */
	public void addBackupDir(String directory, String description){
		BackupDir backupDir = new BackupDir();
		backupDir.directory = directory;
		backupDir.description = description;
		sqlManager.insertEntity(backupDir);
	}

	/**
	 * バックアップディレクトリを削除します。
	 *
	 * @param id バックアップディレクトリのID
	 */
	public void removeBackupDir(Long id){
		BackupDir backupDir = new BackupDir();
		backupDir.id = id;
		sqlManager.deleteEntity(backupDir);
	}

	/**
	 * バックアップディレクトリの情報を更新します。
	 *
	 * @param id バックアップディレクトリのID
	 * @param directory バックアップディレクトリのルートディレクトリ
	 * @param description バックアップディレクトリの説明
	 */
	public void updateBackupDir(Long id, String directory, String description){
		BackupDir backupDir = new BackupDir();
		backupDir.id = id;
		backupDir.directory = directory;
		backupDir.description = description;
		sqlManager.updateEntity(backupDir);
	}

}
