package jp.sf.amateras.rdiffbackup.util;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Statement;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.sql.XADataSource;

import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.SingletonS2Container;

public class DatabaseInitializeServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	@Override
	public void init() throws ServletException {
		super.init();

		getServletContext().log("データベースの準備を開始します。");

		try {
			XADataSource ds = SingletonS2Container.getComponent(XADataSource.class);
			Connection conn = ds.getXAConnection().getConnection();

			try {
				try {
					// テーブルがすでに存在するかチェックする
					getServletContext().log("テーブルが存在するかチェックしています。");

					Statement stmt = conn.createStatement();
					stmt.executeQuery("SELECT * FROM BACKUP_DIRS");
					stmt.close();

				} catch(Exception ex){
					// テーブルが存在しなければ初期化
					getServletContext().log("テーブルを作成します。");

					InputStream in = getClass().getResourceAsStream("/data/create.sql");
					String sql = IOUtils.toString(in, "UTF-8");

					Statement stmt = conn.createStatement();
					stmt.executeUpdate(sql);
					stmt.close();
				}
			} finally {
				conn.close();
			}

		} catch(Exception ex){
			throw new RuntimeException(ex);
		}

		getServletContext().log("データベースの準備が完了しました。");
	}



}
