/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.common.helper;

import java.io.InputStream;

import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressDetailDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressEmailDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressImDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressNameDataBean;
import jp.sourceforge.android_ab.addressbook.addressdetail.data.AddressPhoneDataBean;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Im;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.Data;


public class AddressDetailDataHelper extends BaseDataHelper<AddressDetailDataBean> {
	private AddressDetailDataBean addressBean;
	
	public AddressDetailDataHelper(Context context, Uri contactLookupUri) {
		super(context);
		addressBean = initHelper(contactLookupUri);
		addressBean.setLookupUri(contactLookupUri);
	}

	@Override
	public AddressDetailDataBean getDataBean() {
		// TODO ꂽ\bhEX^u
		return setAllData(addressBean);
	}
	
	public long getContactId() {
		return addressBean.getContactId();
	}
	
	public Uri getLookupUri() {
		return addressBean.getLookupUri();
	}
	
	public InputStream getPhoto() {
//		Uri contactUri = Contacts.getLookupUri(addressBean.getContactId(), addressBean.getLookupKey());
//		Uri photoUri = ContentUris.withAppendedId(Contacts.CONTENT_URI, addressBean.getContactId());
		InputStream photoIs = Contacts.openContactPhotoInputStream(getContentResolver(), getLookupUri());
		
		return photoIs;
	
	}
	
	private AddressDetailDataBean initHelper(Uri contactLookupUri) {
		Cursor cursor = getContentResolver().query(contactLookupUri, null, null, null, null);
		cursor.moveToFirst();
		
		AddressDetailDataBean addressBean = new AddressDetailDataBean();
		addressBean.setContactId(cursor.getInt(cursor.getColumnIndex(Contacts._ID)));
		addressBean.setLookupKey(cursor.getString(cursor.getColumnIndex(Contacts.LOOKUP_KEY)));
		addressBean.setPhotoId(cursor.getInt(cursor.getColumnIndex(Contacts.PHOTO_ID)));
		addressBean.setDisplayName(cursor.getString(cursor.getColumnIndex(Contacts.DISPLAY_NAME)));
		addressBean.setPhoneticName(cursor.getString(cursor.getColumnIndex(Contacts.PHONETIC_NAME)));
		
		return addressBean;
	}
	
	private AddressDetailDataBean setAllData(AddressDetailDataBean addressBean) {
		Cursor cursor = getContentResolver().query(
				Data.CONTENT_URI,
				null,
				Data.CONTACT_ID + " = ?",
				new String[]{String.valueOf(getContactId())},
				null);
		
		while(cursor.moveToNext()) {
			String mimeType = cursor.getString(cursor.getColumnIndex(Data.MIMETYPE));
			
			if(StructuredName.CONTENT_ITEM_TYPE.equals(mimeType)) {
				addressBean.setNameBean(createStructuredNameData(cursor));
			} else if(Phone.CONTENT_ITEM_TYPE.equals(mimeType)) {
				addressBean.addPhoneBean(createPhoneData(cursor));
			} else if(Email.CONTENT_ITEM_TYPE.equals(mimeType)) {
				addressBean.addEmailBean(createEmailData(cursor));
			} else if(Im.CONTENT_ITEM_TYPE.equals(mimeType)) {
				addressBean.addImBean(createImData(cursor));
			}
		}
		
		return addressBean;
	}
	
	private AddressNameDataBean createStructuredNameData(Cursor row) {
		AddressNameDataBean nameBean = new AddressNameDataBean();
		nameBean.setFamilyName(row.getString(row.getColumnIndex(StructuredName.FAMILY_NAME)));
		nameBean.setMiddleName(row.getString(row.getColumnIndex(StructuredName.MIDDLE_NAME)));
		nameBean.setGivenName(row.getString(row.getColumnIndex(StructuredName.GIVEN_NAME)));
		nameBean.setPhoneticFamilyName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_FAMILY_NAME)));
		nameBean.setPhoneticMiddleName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_MIDDLE_NAME)));
		nameBean.setPhoneticMiddleName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_GIVEN_NAME)));
		
		return nameBean;
	}
	
	private AddressPhoneDataBean createPhoneData(Cursor row) {
		AddressPhoneDataBean phoneBean = new AddressPhoneDataBean();
		phoneBean.setNumber(row.getString(row.getColumnIndex(Phone.NUMBER)));
		phoneBean.setType(row.getInt(row.getColumnIndex(Phone.TYPE)));
		phoneBean.setLabel(row.getString(row.getColumnIndex(Phone.LABEL)));
		
		return phoneBean;
	}
	
	private AddressEmailDataBean createEmailData(Cursor row) {
		AddressEmailDataBean emailBean = new AddressEmailDataBean();
		emailBean.setAddress(row.getString(row.getColumnIndex(Email.ADDRESS)));
		emailBean.setType(row.getInt(row.getColumnIndex(Email.TYPE)));
		emailBean.setLabel(row.getString(row.getColumnIndex(Email.LABEL)));
		
		return emailBean;
	}
	
	private AddressImDataBean createImData(Cursor row) {
		AddressImDataBean imBean = new AddressImDataBean();
		imBean.setData(row.getString(row.getColumnIndex(Im.DATA)));
		imBean.setType(row.getInt(row.getColumnIndex(Im.TYPE)));
		imBean.setLabel(row.getString(row.getColumnIndex(Im.LABEL)));
		imBean.setProtocol(row.getString(row.getColumnIndex(Im.PROTOCOL)));
		imBean.setCustomProtocol(row.getString(row.getColumnIndex(Im.CUSTOM_PROTOCOL)));
		
		return imBean;
	}
}
