/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.groupaddresslist.adapter;

import java.io.InputStream;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.adapter.ListAdapter;
import jp.sourceforge.android_ab.addressbook.common.data.AddressDataBean;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.ContactsContract.Contacts;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class AddressListAdapter extends ListAdapter<AddressDataBean> {

	public AddressListAdapter(Context context) {
		super(context);
	}
	
	public AddressListAdapter(Context context, List<AddressDataBean> dataList) {
		super(context, dataList);
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d("com.blogspot.started.a.newleaf.contactlist", "ContactListAdapter#getView: start");

		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.groupaddresslistrow, null);
		
		QuickContactBadge badge = (QuickContactBadge) view.findViewById(R.id.quickContactBadge1);
		TextView displayName = (TextView) view.findViewById(R.id.displayName);
		
		AddressDataBean bean = (AddressDataBean) getItem(position);
		Log.d("com.blogspot.started.a.newleaf.contactlist", "contactId: " + bean.getContactId());
		Log.d("com.blogspot.started.a.newleaf.contactlist", "displayName: " + bean.getDisplayName());

		Uri contactUri = Contacts.getLookupUri(bean.getContactId(), bean.getLookupKey());
		badge.assignContactUri(contactUri);
		Uri photoUri = ContentUris.withAppendedId(Contacts.CONTENT_URI, bean.getContactId());
		InputStream photoIs = Contacts.openContactPhotoInputStream(getContentResolver(), photoUri);
		
		if(photoIs == null) {
			// TODO:
			badge.setImageResource(R.drawable.ic_contact_picture);
		} else {
			badge.setImageBitmap(BitmapFactory.decodeStream(photoIs));
		}
		
		displayName.setText(bean.getDisplayName());
		
		Log.d("com.blogspot.started.a.newleaf.contactlist", "ContactListAdapter#getView: end");
		return view;
	}

}
