package jp.sourceforge.android_ab.addressbook.history.adapter;

import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.adapter.ListAdapter;
import jp.sourceforge.android_ab.addressbook.history.data.ContactHistoryDataBean;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class ContactHistoryListDataAdapter extends ListAdapter<ContactHistoryDataBean> {

	public ContactHistoryListDataAdapter(Context context) {
		super(context);
	}

	public ContactHistoryListDataAdapter(Context context,
			List<ContactHistoryDataBean> dataList) {
		super(context, dataList);
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d("jp.sourceforge.android_ab.addressbook.history", "ContactHistoryListDataAdapter#getView: start");
		
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View row = (View) inflater.inflate(R.layout.historylistrow, null);
		
		ContactHistoryDataBean bean = (ContactHistoryDataBean) getItem(position);
		
		TextView displayName = (TextView) row.findViewById(R.id.displayName);
		displayName.setText(bean.getName());
		
		TextView displayNumber = (TextView) row.findViewById(R.id.otherInfo);
		displayNumber.setText(bean.getNumber());
		
		Log.d("jp.sourceforge.android_ab.addressbook.history", "ContactHistoryListDataAdapter#getView: end");
		return row;
	}
}
