
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *     The tagName parameter in the "createElement(tagName)"
 *    method is case-sensitive for XML documents.
 *    Retrieve the entire DOM document and invoke its 
 *    "createElement(tagName)" method twice.  Once for tagName
 *    equal to "acronym" and once for tagName equal to "ACRONYM"
 *    Each call should create a distinct Element node.  The
 *    newly created Elements are then assigned attributes 
 *    that are retrieved.
 *    Modified on 27 June 2003 to avoid setting an invalid style
 *    values and checked the node names to see if they matched expectations.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=243">http://www.w3.org/Bugs/Public/show_bug.cgi?id=243</a>
*/
public final class hc_documentcreateelementcasesensitive extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public hc_documentcreateelementcasesensitive(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element newElement1;
      Element newElement2;
      String attribute1;
      String attribute2;
      String nodeName1;
      String nodeName2;
      doc = (Document) load("hc_staff", true);
      newElement1 = doc.createElement("ACRONYM");
      newElement2 = doc.createElement("acronym");
      newElement1.setAttribute("lang", "EN");
      newElement2.setAttribute("title", "Dallas");
      attribute1 = newElement1.getAttribute("lang");
      attribute2 = newElement2.getAttribute("title");
      assertEquals("attrib1", "EN", attribute1);
      assertEquals("attrib2", "Dallas", attribute2);
      nodeName1 = newElement1.getNodeName();
      nodeName2 = newElement2.getNodeName();
      assertEqualsAutoCase("element", "nodeName1", "ACRONYM", nodeName1);
        assertEqualsAutoCase("element", "nodeName2", "acronym", nodeName2);
        }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/hc_documentcreateelementcasesensitive";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(hc_documentcreateelementcasesensitive.class, args);
   }
}

