/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package tests.api.java.net;

import junit.framework.TestCase;

import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargetClass;

import java.net.PasswordAuthentication;
import java.net.PortUnreachableException;

@TestTargetClass(PortUnreachableException.class) 
public class PortUnreachableExceptionTest extends TestCase {

    @TestTargetNew(
        level = TestLevel.COMPLETE,
        notes = "",
        method = "PortUnreachableException",
        args = {}
    )
    public void test_Constructor() {
        PortUnreachableException pue = new PortUnreachableException();
        assertNull(pue.getMessage());
    }
 
    @TestTargetNew(
        level = TestLevel.COMPLETE,
        notes = "",
        method = "PortUnreachableException",
        args = {java.lang.String.class}
    )
    public void test_ConstructorLString() {
        String [] messages = {"", null, "Test Message"};
        for(String str:messages) {
            PortUnreachableException pue = new PortUnreachableException(str);
            assertEquals(str, pue.getMessage());
        }
    }    
}
