/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NETD_CLIENT_FWMARK_CLIENT_H
#define NETD_CLIENT_FWMARK_CLIENT_H

#include <sys/socket.h>

struct FwmarkCommand;

class FwmarkClient {
public:
    // Returns true if a socket of the given |family| should be sent to the fwmark server to have
    // its SO_MARK set.
    static bool shouldSetFwmark(int family);

    FwmarkClient();
    ~FwmarkClient();

    // Sends |data| to the fwmark server, along with |fd| as ancillary data using cmsg(3).
    // Returns 0 on success or a negative errno value on failure.
    int send(FwmarkCommand* data, int fd);

private:
    int mChannel;
};

#endif  // NETD_CLIENT_FWMARK_CLIENT_H
