package com.example.android.BluetoothChat;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.widget.Toast;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;

public class MultitouchController extends Activity {
	static final int CONTROLLER_STATE_IDLE = 0;
	static final int CONTROLLER_STATE_TOUCHSINGLE = 1;
	static final int CONTROLLER_STATE_ACTIVE = 2;
	static final int CONTROLLER_STATE_ERROR = 3;
    // Intent request codes
    private static final int REQUEST_CONNECT_DEVICE = 1;
    private static final int REQUEST_ENABLE_BT = 2;
    
    
	int mControllerState;
	byte motorPower_l = 0;
	byte motorPower_r = 0;
	byte handPower_l = 0;
	byte handPower_r = 0;
	boolean handControl = false;
	
	private BluetoothChatService mChatService = null;
    // Message types sent from the BluetoothChatService Handler
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;
    private static final String TAG = "BluetoothChat";
    private static final boolean D = true;
    private BluetoothAdapter mBluetoothAdapter = null;
    private boolean bStop;
    
    private int mScreenSize_X;
    private int mScreenSize_Y;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                
    	mControllerState = CONTROLLER_STATE_IDLE;
    	motorPower_l = 0;
    	motorPower_r = 0;
    	
    	super.onCreate(savedInstanceState);

    	{
    		// XN[TCY擾 2011.04.09 yishii
    		DisplayMetrics metrics = new DisplayMetrics();
    		this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
    		mScreenSize_X = metrics.widthPixels;
    		mScreenSize_Y = metrics.heightPixels;
    	}
    	
    	
        if (mChatService == null) {
        	// setup
        	mChatService = new BluetoothChatService(this, mHandler);
        }
    }
    
    @Override
    public void onStart(){
    	super.onStart();

    }
    
    @Override
    public void onResume() {
        super.onResume();

        debug_msg("thread started");
    	bStop = false;
        new Thread(runnable).start();
    }
    
    @Override
    public void onPause() {
    	super.onPause();
    	bStop = true;
    }

    @Override
    public void onStop() {
        super.onStop();
        debug_msg("onStop");
    }

    @Override
    public void onDestroy() {
    	super.onDestroy();
    	debug_msg("onDestroy");
    	if(mChatService!=null){
    		mChatService.stop();
    		mChatService = null;
    	}
    }
    
    @Override
    public boolean onTouchEvent(MotionEvent event)
    {
//    	debug_msg("onTouchEvent");
    	int pointerCount;
    	
    	
    	if(event.getAction() == MotionEvent.ACTION_UP){
    		motorPower_l = motorPower_r = 0;    		
    	} else {
	    	pointerCount = event.getPointerCount();
	
	    	switch(pointerCount){
	    	case 1:
	    		// 蔲ŃX~}Z...
	    		convertPositionToMotorPower(event.getX(0),event.getY(0),event.getX(0),event.getY(0));
	    		break;
	    	case 2:
	    		debug_msg("dual_touch mode!");
	    		handControl = false;
	    		convertPositionToMotorPower(event.getX(0),event.getY(0),event.getX(1),event.getY(1));
	    		break;
	    	case 3:
	    		handControl = false;
	    		break;
	    	case 4:
	    		handControl = true;
	
	    		convertPositionToHandPower(event.getX(0),event.getY(0),event.getX(1),event.getY(1));
	    		convertPositionToMotorPower(event.getX(2),event.getY(2),event.getX(3),event.getY(3));
	    		break;
	    	default:
	    		motorPower_l = motorPower_r = 0;
	    		break;
	    	}
    	}
    	
    	return true;
    }

    private void sendMessage(byte[] data) {
    	//debug_msg("sendMessage *************************");
        // Check that we're actually connected before trying anything
        if (mChatService.getState() != BluetoothChatService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }

        // Get the message bytes and tell the BluetoothChatService to write
        mChatService.write(data);
    }
        
    private void convertPositionToMotorPower(float x1,float y1,float x2,float y2)
    {
    	byte motor_l;
    	byte motor_r;
    	float position_l;
    	float position_r;
    	
    	if(x1 > x2){
    		position_l = y1;
    		position_r = y2;
    	} else {
    		position_l = y2;
    		position_r = y1;
    	}
    	
    	{
    		// only designed for Nexus S screen
    		
    		// limitter
    		position_l = position_l >= mScreenSize_Y ? mScreenSize_Y : position_l;
    		position_r = position_r >= mScreenSize_Y ? mScreenSize_Y : position_r;
    		
    		// normalization
    		position_l = (position_l * 256) / mScreenSize_Y;
    		position_r = (position_r * 256) / mScreenSize_Y;

    		motor_l = (byte) ((position_l) - 128);
    		motor_r = (byte) ((position_r) - 128);
    	
    		//Log.v("Motor", "POWER_L = " + motor_l + " POWER_R = " + motor_r);
    		
    		motorPower_l = motor_l;
    		motorPower_r = motor_r;
    	}
    }
    private void convertPositionToHandPower(float x1,float y1,float x2,float y2)
    {
    	byte motor_l;
    	byte motor_r;
    	float position_l;
    	float position_r;
    	
    	if(x1 > x2){
    		position_l = y1;
    		position_r = y2;
    	} else {
    		position_l = y2;
    		position_r = y1;
    	}
    	
    	{
    		// only designed for Nexus S screen
    		
    		// limitter
    		position_l = position_l >= mScreenSize_Y ? mScreenSize_Y : position_l;
    		position_r = position_r >= mScreenSize_Y ? mScreenSize_Y : position_r;
    		
    		// normalization
    		handPower_l = (byte)(((position_l * 179) / mScreenSize_Y)+1);
    		handPower_r = (byte)(((position_r * 179) / mScreenSize_Y)+1);

    	}
    }
    
    // The Handler that gets information back from the BluetoothChatService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
            case MESSAGE_STATE_CHANGE:
                if(D) Log.i(TAG, "MESSAGE_STATE_CHANGE: " + msg.arg1);
                switch (msg.arg1) {
                case BluetoothChatService.STATE_CONNECTED:
                    break;
                case BluetoothChatService.STATE_CONNECTING:
                    break;
                case BluetoothChatService.STATE_LISTEN:
                case BluetoothChatService.STATE_NONE:
                    break;
                }
                break;
            case MESSAGE_WRITE:
                byte[] writeBuf = (byte[]) msg.obj;
                // construct a string from the buffer
                String writeMessage = new String(writeBuf);
                break;
            case MESSAGE_READ:
                byte[] readBuf = (byte[]) msg.obj;
                // construct a string from the valid bytes in the buffer
                String readMessage = new String(readBuf, 0, msg.arg1);
                debug_msg(readMessage);
                break;
            case MESSAGE_DEVICE_NAME:
                // save the connected device's name
                break;
            case MESSAGE_TOAST:
                break;
            }
        }
    };
    

    private Runnable runnable = new Runnable()
    {

		public void run() {
			final byte data[] = new byte[4];
			boolean switchFlag = false;
			
			while(!bStop){
				try{
					Thread.sleep(100);
				} catch(InterruptedException e) {
					debug_msg("InterruptedException detected");
				}
				
				if(switchFlag == false){
					data[0] = 3;
					data[1] = 0x20;
					data[2] = motorPower_l;
					data[3] = motorPower_r;
					switchFlag = true;
				} else {
					data[0] = 3;
					data[1] = 0x21;
					data[2] = handPower_l;
					data[3] = handPower_r;					
					switchFlag = false;
				}
				mHandler.post(new Runnable(){
					public void run()
					{
						sendMessage(data);
					}
				});

			}			
		}
    };
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(D) Log.d(TAG, "onActivityResult " + resultCode);
        switch (requestCode) {
        case REQUEST_CONNECT_DEVICE:
            // When DeviceListActivity returns with a device to connect
            if (resultCode == Activity.RESULT_OK) {
                // Get the device MAC address
                String address = data.getExtras()
                                     .getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS);
                // Get the BLuetoothDevice object
                BluetoothDevice device = mBluetoothAdapter.getRemoteDevice(address);
                // Attempt to connect to the device
                mChatService.connect(device);
            }
            break;
        case REQUEST_ENABLE_BT:
            // When the request to enable Bluetooth returns
            if (resultCode == Activity.RESULT_OK) {
                // Bluetooth is now enabled, so set up a chat session
                //setupChat();
            } else {
                // User did not enable Bluetooth or an error occured
                Log.d(TAG, "BT not enabled");
                Toast.makeText(this, R.string.bt_not_enabled_leaving, Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.option_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	Intent serverIntent;
        switch (item.getItemId()) {
        case R.id.scan:
            // Launch the DeviceListActivity to see devices and do scan
            serverIntent = new Intent(this, DeviceListActivity.class);
            startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
            return true;
        case R.id.discoverable:
            // Ensure this device is discoverable by others
            //ensureDiscoverable();
            return true;
        case R.id.multitouchcontoller:
        	Log.v("DEBUG","Multitouch controller launching...");
        	serverIntent = new Intent(this, MultitouchController.class);
        	startActivity(serverIntent);
        	return true;
        }
        return false;
    }
    private void debug_msg(String s)
    {
    	Log.v(Constants.LOG_TAG,this.toString() + s );
    }

}
