! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> author: Kannan Masilamani
!! This module contains some aux routines for libharvesting
!!
module hvs_aux_module

  ! include treelm modules
  use env_module,           only: labelLen
  use tem_solveHead_module, only: tem_solveHead_type
  use tem_logging_module,   only: logUnit
  use tem_aux_module,       only: tem_print_execInfo, utc_date_string

  implicit none

  private

  public :: hvs_banner

contains

! ****************************************************************************** !
  !> Print harvester banner to screen
  !!
  subroutine hvs_banner( solveHead, supportSolName )
    ! ---------------------------------------------------------------------------
    type( tem_solveHead_type )  :: solveHead
    !> Name of the solver which invokes this routine
    character(len=*) :: supportSolName
    ! ---------------------------------------------------------------------------
    character(len=26) :: dat_string
    ! ---------------------------------------------------------------------------

    write(logunit(0),*)"                                                          "
    write(logunit(0),*)"        __                               __               "
    write(logunit(0),*)"       / /_  ____  ______   _____  _____/ /____  _____    "
    write(logunit(0),*)"      / __ \/ __ \/ ___/ | / / _ \/ ___/ __/ _ \/ ___/    "
    write(logunit(0),*)"     / / / / /_/ / /   | |/ /  __(__  ) /_/  __/ /        "
    write(logunit(0),*)"    /_/ /_/\____/_/    |___/\___/____/\__/\___/_"         &
      &                                                  //trim(solveHead%version)
    write(logunit(0),*)"                                                          "
    write(logunit(0),*)" (C) 2012 German Research School for Simulation Sciences  "
    write(logunit(0),*)"                                                          "
    call tem_print_execInfo()
    write(logunit(0),*)""
    write(logunit(0),*)"With "//trim(supportSolName)//" support."
    write(logunit(0),*)""
    dat_string = utc_date_string()
    write(logUnit(1),*)"Run at: "//trim(dat_string)
    write(logUnit(1),*)""
    write(logunit(0),*)"----------------------------------------------------------"

  end subroutine hvs_banner
! ****************************************************************************** !

end module hvs_aux_module
! ****************************************************************************** !
