! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines to load the adaptation parameters
module tem_adaptation_config_module

  !include treelm modules
  use tem_timeControl_module,       only: tem_timeControl_type,                &
    &                                     tem_timeControl_load
  use tem_aux_module,               only: tem_abort
  use tem_logging_module,           only: logUnit

  !include aotus modules
  use aotus_module,           only: flu_State, aot_get_val,aoterr_NonExistent
  use aot_table_module,       only: aot_table_open, aot_table_close,           &
    &                               aot_table_length, aot_get_val

  implicit none
  private

  public :: tem_adapt_type
  public :: tem_load_adapt

  !> Datatype containig information about adaptation of the mesh
  type tem_adapt_type
    !>Contains variables which are requested in a lua file
    type(tem_timeControl_type) :: time

    !> is adaptation active?
    logical :: active = .false.
  end type tem_adapt_type

contains

! ****************************************************************************** !
  !> Load variables, parent scheme and conditions defined in lua file.
  subroutine tem_load_adapt( me, conf )
    ! ---------------------------------------------------------------------------
    !> adapt_type to be filled
    type( tem_adapt_type ), intent(inout) :: me
    !> lua state to read from
    type( flu_state ), intent(in)         :: conf
    ! ---------------------------------------------------------------------------
    integer :: adapt_handle
    ! ---------------------------------------------------------------------------

    ! Open the adapt table
    call aot_table_open( L       = conf,                                       &
      &                  thandle = adapt_handle,                               &
      &                  key     = 'adaptation' )

    if ( adapt_handle /= 0 ) then
      ! get timeControl conditions
      call tem_timeControl_load( me     = me%time,                             &
        &                        conf   = conf,                                &
        &                        parent = adapt_handle )

      me%active = .TRUE.
      write(logUnit(1),"(A)") 'Mesh Adaptation is active!'
    end if
    ! close the adaptation table
    call aot_table_close( L=conf, thandle=adapt_handle )

  end subroutine tem_load_adapt
! ****************************************************************************** !

end module tem_adaptation_config_module
! ****************************************************************************** !
