! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> Module to provide simple growing data structures.
!! The dynamic arrays provided by this module are
!! capable of handling lists of values, which might
!! need to grow over time.
!! Removal of entries is not possible directly.
!! The complete module might be put into a CoCo Text
!! template, to create new modules of this object
!! for different types. For now, two different
!! templates are used for the declaration part and
!! the implementation part.
?? include 'arrayMacros.inc'
!!
module tem_grow_array_module

  ! include treelm modules
  use env_module, only: long_k, rk, minLength, zeroLength, labelLen

  implicit none

  type intArray2d_type
    integer, allocatable :: val(:,:)
  end type

! -----------------------------------------------------------------
! Growing array (GA)
! tname ... indicates type of dynamic array (long, int, real, ...)

?? copy :: GA_decltxt(logical, logical)
?? copy :: GA_decltxt(long, integer(kind=long_k))
?? copy :: GA_decltxt(int, integer)
?? copy :: GA_decltxt(real, real(kind=rk))
?? copy :: GA_decltxt(dtInt2d, type(intArray2d_type))
?? copy :: GA_decltxt(label, character(len=labelLen))
?? copy :: GA_decltxt(char, character)

! Growing array
! -----------------------------------------------------------------


! -----------------------------------------------------------------
! Growing array (GA2d)
! tname ... indicates type of dynamic array (long, int, real, ...)
! 2d array, but only the second dimension can grow.
!

?? copy :: GA2d_decltxt(char, character)
?? copy :: GA2d_decltxt(logical, logical)
?? copy :: GA2d_decltxt(long, integer(kind=long_k))
?? copy :: GA2d_decltxt(int, integer)
?? copy :: GA2d_decltxt(real, real(kind=rk))

! Growing array 2D
! -----------------------------------------------------------------




contains

! -----------------------------------------------------------------
! Growing array (GA)
! tname ... indicates type of dynamic array (long, int, real, ...)

?? copy :: GA_impltxt(logical, logical)
?? copy :: GA_impltxt(long, integer(kind=long_k))
?? copy :: GA_impltxt(int, integer)
?? copy :: GA_impltxt(real, real(kind=rk))
?? copy :: GA_impltxt(dtInt2d, type(intArray2d_type))
?? copy :: GA_impltxt(label, character(len=labelLen), character(len=*))
?? copy :: GA_impltxt(char, character)
! Growing array
! -----------------------------------------------------------------



! ****************************************************************************** !
! -----------------------------------------------------------------
! 2d Array, which can grow in second dimension only (GA2d)
! tname ... indicates type of dynamic array (long, int, real, ...)

?? copy :: GA2d_impltxt(char, character, '')
?? copy :: GA2d_impltxt(logical, logical, .false.)
?? copy :: GA2d_impltxt(long, integer(kind=long_k), -1_long_k)
?? copy :: GA2d_impltxt(int, integer, -1)
?? copy :: GA2d_impltxt(real, real(kind=rk), -1.0_rk)

! Growing array 2D
! -----------------------------------------------------------------


end module tem_grow_array_module
! ****************************************************************************** !
