module tem_operation_module

  use, intrinsic :: iso_c_binding,    only: c_ptr, c_f_pointer
  use env_module,                     only: globalMaxLevels
  use tem_grow_array_module,          only: grw_intArray_type
  use tem_reduction_transient_module, only: tem_reduction_transient_type

  implicit none

  private

  public :: tem_indexLvl_type
  public :: tem_varSys_op_data_type

  !> Type to store the index of points of the inputs
  !! levelwise, since points are levelwise
  type tem_indexLvl_type
    type( grw_intArray_type) :: indexLvl(globalMaxLevels)
  end type tem_indexLvl_type

  !> Type which is the method_data for derived variables, hence it
  !! consists of the point index for each input variable
  !! size: number of inputs variable
  type tem_varSys_op_data_type
    type(tem_indexLvl_type), allocatable :: input_pntIndex(:)

    !> A pointer to possibly additional solver data.
    !!
    !! This is for example used to keep a link to the projection data
    !! in Ateles to enable the construction of element data from the
    !! point data for the operation variables.
    type(c_ptr) :: solver_bundle

    !> time reduction data
    type(tem_reduction_transient_type) :: redTrans
  end type tem_varSys_op_data_type

contains


end module tem_operation_module
