! See copyright notice in the COPYRIGHT file.
program tem_polygon_material_test
  use tem_polygon_material_module

  implicit none

  logical :: angle_is_correct
  logical :: containment_is_correct

  call tem_polygon_material_test_angle(angle_is_correct)

  if (.not. angle_is_correct) then
    write(*,*) 'FAILED to compute angles correctly!'
  else
    write(*,*) 'angles computed correctly'
  end if

  write(*,*) ''
  write(*,*) '----------------------------------------'
  write(*,*) ''

  call tem_polygon_material_test_value(containment_is_correct)

  if (.not. containment_is_correct) then
    write(*,*) 'FAILED to compute containment correctly!'
  else
    write(*,*) 'containment computed correctly'
  end if

  if (angle_is_correct .and. containment_is_correct) then
    write(*,*) 'PASSED'
  end if

end program tem_polygon_material_test
