! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module encapsulates the available isNaN implementation
!!
!! Here we use a dummy routine, which always returns false, as
!! neither the IEEE version nor a vendor specific isNaN is
!! available by the compiler.
!!
module tem_isNaN_module

  ! include treelm modules
  use env_module, only: rk

  implicit none

  private

  public :: tem_isNaN


  contains

! ****************************************************************************** !
  elemental function tem_isNaN(num) result(noNumber)
    !---------------------------------------------------------------------------
    real(kind=rk), intent(in) :: num
    logical :: noNumber
    !---------------------------------------------------------------------------

    noNumber = .false.

  end function tem_isNaN
! ****************************************************************************** !


end module tem_isNaN_module
! ****************************************************************************** !
