! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module gathers information for the scalar cylindrical wave.
!!
module tem_cylindricalWave_module

  ! include treelm modules
  use env_module,         only: rk
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  ! include aotus modules
  use aotus_module,     only: aoterr_NonExistent, flu_state
  use aot_table_module, only: aot_table_open, aot_table_close,                 &
   &                          aot_table_length, aot_get_val

  implicit none

  public :: tem_load_cylindricalWave, tem_cylindricalWave_type, &
          & tem_eval_cylindricalWave

  !> This type contains datas to define the scalar cylindrical wave.
  type tem_cylindricalWave_type
    !> The wave order
    integer :: order
    !> The radial constant
    real(kind=rk) :: radialConstant
    !> The cut radius of the cylindrical wave
    real(kind=rk) :: radius
  end type tem_cylindricalWave_type


contains

  !> Load definition of the scalar cylindrical wave.
  subroutine tem_load_cylindricalWave(conf, thandle, me)
    ! ---------------------------------------------------------------------------
    !> lua state type
    type(flu_State) :: conf
    !> aotus parent handle
    integer, intent(in) :: thandle
    type(tem_cylindricalWave_type), intent(out) :: me
    ! ---------------------------------------------------------------------------
    integer :: iError
    ! ---------------------------------------------------------------------------

    write(logUnit(0),*)'ERROR: the cylindrical wave function is not available' &
      &                // ' in this'
    write(logUnit(0),*)'       executable, due to the compiler lacking ' &
      &                // 'support of'
    write(logUnit(0),*)'       Bessel functions!'
    call tem_abort()

  end subroutine tem_load_cylindricalWave


  !> Calculate the function values for the cylindrical wave.
  function tem_eval_cylindricalWave(me, coord, time, n)  result(res)
    !> Spacetime function to evaluate
    type(tem_cylindricalWave_type) :: me
    !> Number of arrays to return
    integer, intent(in) :: n
    !> barycentric Ids of an elements.
    !! 1st index goes over number of elements and
    !! 2nd index goes over x,y,z coordinates
    real(kind=rk), intent( in ) :: coord(n,3)
    !> The current physical time
    real(kind=rk), intent( in )  :: time
    !> return value
    real(kind=rk) :: res(n)
    ! ---------------------------------------------------------------------------
    real(kind=rk) :: polar(n,2)
    integer :: i
    ! ---------------------------------------------------------------------------

    res = 0.0_rk

  end function tem_eval_cylindricalWave


end module tem_cylindricalWave_module
