! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module provides rotations of a child cell and
!! its relations to direct neighbors
!!
module tem_rotation_module

  ! include treelm modules
  use tem_param_module,    only: childPosition, tem_rotationMatrix

  implicit none

  private
  public :: tem_assign_rotatedNeighbors
  public :: tem_assign_rotatedNeighbors_ref2d

  contains

! ****************************************************************************** !
  !> Sets the source coordinate for the rotated unit cube
  !!
  function tem_assign_rotatedNeighbors( iCase ) result( rotCoord )
    ! ---------------------------------------------------------------------------
    !>
    integer, intent(in)    :: iCase
    !> rotated coordinates
    integer   :: rotCoord(3,8)
    ! ---------------------------------------------------------------------------
    integer   :: curCoord(3)
    integer   :: iNeigh
    ! ---------------------------------------------------------------------------
    do iNeigh = 1,8
      curCoord = childPosition( iNeigh, : )
      rotCoord( :, iNeigh ) = matmul(transpose(tem_rotationMatrix(:,:,iCase)), &
        &                            curCoord )
      rotCoord = (rotCoord+1)/2
    enddo
   end function tem_assign_rotatedNeighbors
! ****************************************************************************** !


! ****************************************************************************** !
  !> Sets the source coordinate for the rotated unit cube
  !!
  function tem_assign_rotatedNeighbors_ref2d( iCase ) result( sourceCoord )
    ! ---------------------------------------------------------------------------
    !>
    integer, intent(in)    :: iCase
    !> source coordinates
    integer  :: sourceCoord(3,4)
    ! ---------------------------------------------------------------------------

    sourceCoord = 0
    select case( iCase )
    case( 1)
      ! Child num 1: 0.75 0.75
      sourceCoord(:, 1) = (/ 1, 1, 0 /)
      sourceCoord(:, 2) = (/ 0, 1, 0 /)
      sourceCoord(:, 3) = (/ 1, 0, 0 /)
      sourceCoord(:, 4) = (/ 0, 0, 0 /)
    case( 2)
      ! Child num 2: 0.25 0.75
      sourceCoord(:, 1) = (/ 0, 1, 0 /)
      sourceCoord(:, 2) = (/ 0, 0, 0 /)
      sourceCoord(:, 3) = (/ 1, 1, 0 /)
      sourceCoord(:, 4) = (/ 1, 0, 0 /)
    case( 3)
      ! Child num 3: 0.75 0.25
      sourceCoord(:, 1) = (/ 1, 0, 0 /)
      sourceCoord(:, 2) = (/ 1, 1, 0 /)
      sourceCoord(:, 3) = (/ 0, 0, 0 /)
      sourceCoord(:, 4) = (/ 0, 1, 0 /)
    case( 4)
      ! Child num 4: 0.25 0.25
      sourceCoord(:, 1) = (/ 0, 0, 0 /)
      sourceCoord(:, 2) = (/ 1, 0, 0 /)
      sourceCoord(:, 3) = (/ 0, 1, 0 /)
      sourceCoord(:, 4) = (/ 1, 1, 0 /)
    case( 5)
      ! Child num 1: 0.75 0.75
      sourceCoord(:, 1) = (/ 1, 1, 1 /)
      sourceCoord(:, 2) = (/ 0, 1, 1 /)
      sourceCoord(:, 3) = (/ 1, 0, 1 /)
      sourceCoord(:, 4) = (/ 0, 0, 1 /)
    case( 6)
      ! Child num 2: 0.25 0.75
      sourceCoord(:, 1) = (/ 0, 1, 1 /)
      sourceCoord(:, 2) = (/ 0, 0, 1 /)
      sourceCoord(:, 3) = (/ 1, 1, 1 /)
      sourceCoord(:, 4) = (/ 1, 0, 1 /)
    case( 7)
      ! Child num 3: 0.75 0.25
      sourceCoord(:, 1) = (/ 1, 0, 1 /)
      sourceCoord(:, 2) = (/ 1, 1, 1 /)
      sourceCoord(:, 3) = (/ 0, 0, 1 /)
      sourceCoord(:, 4) = (/ 0, 1, 1 /)
    case( 8)
      ! Child num 4: 0.25 0.25
      sourceCoord(:, 1) = (/ 0, 0, 1 /)
      sourceCoord(:, 2) = (/ 1, 0, 1 /)
      sourceCoord(:, 3) = (/ 0, 1, 1 /)
      sourceCoord(:, 4) = (/ 1, 1, 1 /)
    end select

   end function tem_assign_rotatedNeighbors_ref2d
! ****************************************************************************** !


end module tem_rotation_module
! ****************************************************************************** !
