! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> author: Simon Zimny
!! author: Kartik Jain
!!
!! A module to provide informations on vertex property for elements.
!!
module tem_vrtx_prop_module

  ! include treelm modules
  use tem_prophead_module, only: tem_prophead_type
  use tem_property_module, only: tem_property_type

  implicit none

  private

  public :: tem_vrtx_prop_type

  !> Datatype for deformed elements, which is filled in Seeder
  type tem_vrtx_prop_type
    !> Pointer to treelmesh_type%global%property
    type(tem_prophead_type),  pointer :: header => null()
    !> Pointer to treelmmesh_type%property
    type(tem_property_type),  pointer :: property => null()
  end type tem_vrtx_prop_type

!HK: Empty contains section allowed by the standard only recently.
!HK: Some compilers might be confused by it, do not use it!
!HK contains

end module tem_vrtx_prop_module
! ****************************************************************************** !
