! See copyright notice in the COPYRIGHT file.
program tem_construction_test
  use env_module, only: long_k
  use tem_construction_module, only: tem_find_depProc_globSearch !, tem_find_BCs_fromCoarser
  use tem_element_module, only: tem_element_type
  use tem_stencil_module, only: tem_stencilHeader_type, tem_create_d3q19, &
    &                           init, append
  use tem_topology_module, only: tem_path_type, tem_pathof

  implicit none

  logical :: passed

  passed = .true.
  write(*,*) 'Running tem_construction_test...'
  call check_find_depProc
  call check_find_BCs_fromCoarser

  if (passed) then
    write(*,*) 'PASSED'
  else
    write(*,*) 'FAILED'
  end if

contains

  subroutine check_find_depProc()
    integer(kind=long_k) :: part_first(16)
    integer(kind=long_k) :: part_last(16)
    type(tem_path_type) :: pathFirst(16)
    type(tem_path_type) :: pathLast(16)
    type(tem_path_type) :: neighpath
    integer :: depProc
    integer :: nDepProcs
    integer :: iTID
    logical :: failure

    part_first=[ 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69]
    part_last =[12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72]

    pathFirst     =  tem_PathOf(Part_First)
    pathLast      =  tem_PathOf(Part_Last)

    write(*,*) ' * checking tem_find_depProc...'

    write(*,*) '   checking all 64 elements on level 2, in 16 partitions:'
    failure = .false.
    do iTID=9,72
      neighpath = tem_PathOf(int(iTID, kind=long_k))
      call tem_find_depProc_globSearch(depProc, nDepProcs, &
        &                    neighPath, 1, 16, pathFirst, pathLast)
      if (nDepProcs /= 1) then
        write(*,*) '   - ERROR for treeID ', iTID, ': nDepProcs /= 1!'
        write(*,*) '     depProc: ', depProc
        failure = .true.
      else
        if (depProc /= (iTID-5)/4) then
          write(*,*) '   - ERROR for treeID ', iTID, ': wrong partition'
          write(*,*) '     is: ', depProc, '; should be:', (iTID-5)/4
          failure = .true.
        end if
      end if
    end do

    if (failure) then
      write(*,*) '   > FAILURE in tem_find_depProc single level'
      passed = .false.
    else
      write(*,*) '   > SUCCESS in tem_find_depProc single level'
    end if

    write(*,*) '   checking all 8 elements on level 1, in 16 partitions:'
    failure = .false.
    do iTID=1,8
      neighpath = tem_PathOf(int(iTID, kind=long_k))
      call tem_find_depProc_globSearch(depProc, nDepProcs, &
        &                    neighPath, 1, 16, pathFirst, pathLast)
      if (nDepProcs /= 2) then
        write(*,*) '   - ERROR for treeID ', iTID, ': nDepProcs /= 2!'
        write(*,*) '     depProc: ', depProc
        failure = .true.
      else
        if (depProc /= (iTID*2)-1) then
          write(*,*) '   - ERROR for treeID ', iTID, ': wrong first partition'
          write(*,*) '     is: ', depProc, '; should be:', (iTID*2)-1
          failure = .true.
        end if
      end if
    end do

    if (failure) then
      write(*,*) '   > FAILURE in tem_find_depProc coarse level'
      passed = .false.
    else
      write(*,*) '   > SUCCESS in tem_find_depProc coarse level'
    end if

    write(*,*) ' --------------------------------------------'
    write(*,*)

  end subroutine check_find_depProc

  subroutine check_find_BCs_fromCoarser
    type(tem_stencilHeader_type) :: d3q19_stencil
    logical :: failure

    failure = .false.
    call tem_create_d3q19(d3q19_stencil)
    !HK: Interface changed, please adapt as needed
    !HK! call init(sourceElem%stencil, length=1)
    !HK! call append(sourceElem%stencil, d3q19_stencil)

    write(*,*) ' * checking tem_find_BCs_fromCoarser...'


   if (failure) then
      write(*,*) '   > FAILURE in tem_find_depProc coarse level'
      passed = .false.
    else
      write(*,*) '   > SUCCESS in tem_find_depProc coarse level'
    end if

    write(*,*) ' --------------------------------------------'
    write(*,*)

  end subroutine check_find_BCs_fromCoarser

end program tem_construction_test
