! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> Module to provide access to the gamma function.
!!
!! This module is used, to provide an adapter to the
!! Gamma function implementation by NAG.
!! It is only used if the NAG implementation is supported,
!! and the compiler itself lacks this F2008 feature.
!!
module tem_gamma_module

  ! include treelm modules
  use nag_library, only: s14aaf, nag_wp

  implicit none

  logical,parameter :: elemental_gamma = .false.

  contains

! ****************************************************************************** !
  !> @todo: Add description
  !!
  function gamma(xx)
    ! ---------------------------------------------------------------------------
    real(kind=nag_wp), intent(in) :: xx
    real(kind=nag_wp) :: gamma
    ! ---------------------------------------------------------------------------
    integer :: iFail
    ! ---------------------------------------------------------------------------

    gamma = s14aaf(xx, iFail)

  end function gamma
! ****************************************************************************** !


end module tem_gamma_module
! ****************************************************************************** !
