! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> Module to provide access to the gamma function.
!!
!! This dummy module is used, if the compiler does not
!! support this F2008 feature, and the NAG implementation
!! is not found.
!! We fallback to the gamma function provided by SLATEC.
!!
module tem_gamma_module

  ! include treelm modules
  use env_module, only: rk

  implicit none

  private

  logical, parameter, public :: elemental_gamma = .false.

  public :: gamma

contains


! ****************************************************************************** !
  !> Wrapper around the SLATEC gamma implementation.
  !!
  elemental function gamma(xx)
    ! ---------------------------------------------------------------------------
    real(kind=rk),intent(in) :: xx
    real(kind=rk) :: gamma
    ! ---------------------------------------------------------------------------
    double precision, external :: dgamma

    gamma = real(dgamma(xx), kind=rk)

  end function gamma
! ****************************************************************************** !


end module tem_gamma_module
! ****************************************************************************** !
