/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <cs89712/ioregs.h>
#include <target/medium.h>
#include <target/gunzip.h>
#include "eth.h"
#include <target/flash.h>
#include <target/frob.h>
#include "linux.h"
#include "memmap.h"

#include <target/setenv.h>

/* timeout for auto-boot, in seconds */
#define BOOT_TIMEOUT 5

char *target_profile = TARGET_PROFILE;

static const command_t *commands[] = {
	&help_command,
	&boot_command,
	&clearenv_command,
	&download_command,
	&flash_erase_command,
	&ether_mac_command,
	&frob_command,
	&jump_command,
	&linux_command,
	&medium_command,
	&memmap_command,
	&flash_program_command,
	&setenv_command,
	&unzip_command,
	&upload_command,
	&version_command,
	0
};

ABBR(boot_command, 'b')
ABBR(help_command, '?')
ABBR(frob_command, 'f')
ABBR(version_command, 'V')

static const abbrev_t *abbrevs[] = {
	&boot_command_abbrev,
	&help_command_abbrev,
	&frob_command_abbrev,
	&version_command_abbrev,
	0
};

static inline void maybe_start_linux(void)
{
#if defined STANDALONE
	/* always go to the command loop */
#else
	/* boot linux unless a key is pressed before the timeout elapses */
	hprintf("Press a key within %d seconds for console.\n", BOOT_TIMEOUT);
	IO_RTCMR = IO_RTCDR + BOOT_TIMEOUT;
	while (IO_SYSFLG1 & URXFE1) {
		if (IO_RTCMR <= IO_RTCDR) {
			/* start linux */
		}
	}
#endif
}

int hmain(void)
{
	command_list_t command_list = { commands, abbrevs, "hermit", 0 };

	flash_initialize(FLASH_TYPE_AMD, FLASH_BANK1_START);

	maybe_start_linux();

	/* startup stuff: activate LED and print version string */
	(*version_command.func)(0, 0);
	init_crc32();
#if defined RELOCATE
	(*boot_command.func)(0, 0);
#endif
	IO_LEDFLSH = 0x7c;	/* LED continuous on */
	do_command_loop(&command_list);
	for (;;);
}

