#ifndef _HERMIT_TARGET_PLATFORM_BOARD_H_
#define _HERMIT_TARGET_PLATFORM_BOARD_H_

#define CLK_399MHZ		(399)
#define CLK_532MHZ		(532)

#define MPCTL_FPM_399		(0x073533bf)
#define MPCTL_FPM_532		(0x027123df)
#define MPCTL_FPM_DEFAULT	(MPCTL_FPM_399)
#define MPCTL_CKIH_399		(0x000c1c09)
#define MPCTL_CKIH_532		(0x0026280a)
#define MPCTL_CKIH_DEFAULT	(MPCTL_CKIH_399)

/* USB PLL = 240000000 Hz */
#define UPCTL_FPM_240		(0x0af32f33)
#define UPCTL_CKIH_240		(0x000c17fb)

/* Serial PLL = 294912000 Hz */
#define SPCTL_FPM_294		(0x047f2065)
#define SPCTL_CKIH_294		(0x07dc2d53)

/* PDR0: Post Divider Register 0 */
/* 399MHz@0xff831650 MCU:1, MAX:3, IPG:2, NFC:7, HSP:3, PER:4, CSI:512
 * 512MHz@0xff831e58 MCU:1, MAX:4, IPG:2, NFC:7, HSP:3, PER:4, CSI:512
 */
#define PDR0_399MHZ		(0xff831650)
#define PDR0_532MHZ		(0xff831658)
#define PDR0_DEFAULT		(PDR0_399MHZ)

/* PDR1: Post Divider Register 1 (POST,PRE) */
/* ---MHz@0x49FCFE7F SSI1:12,1 SSI2:12,1 FIRI:64,2 USB:2,2
 */
#define PDR1_DEFAULT		(0x49fc160b)

#ifndef __ASSEMBLER__

struct board_info {
	u8 jumper1;
	u8 jumper2;
	u32 cpu_board_id;
#if defined(HAVE_BASE_BOARD_ID)
	u32 base_board_id;
#endif
};

extern void led_on(void);
extern void led_off(void);

extern void udelay(unsigned long usec);
extern void mdelay(unsigned long msec);

extern int is_autoboot_mode(void);
extern void board_init(void);

extern void mxc_set_mux(u32 mux, u32 config);
extern u32 mxc_get_mux(u32 mux);
extern void mxc_set_pad(u32 pad, u32 config);

extern int mxc_get_gpio(u32 gpio);
extern void mxc_set_gpio(u32 gpio, u32 direction, u32 data);
#define GPIO_INPUT	(0)
#define GPIO_OUTPUT	(1)
#define GPIO_LOW	(0)
#define GPIO_HIGH	(1)

#if defined(ARMADILLO500DEV)
# include "board-dev.h"
#endif
#if defined(ARMADILLO500FX)
# include "board-fx.h"
#endif
#if defined(ZERO)
# include "board-zero.h"
#endif

#define TARGET_NAME_LEN 256
extern char target_name[TARGET_NAME_LEN];
extern char *target_profile;

extern struct board_info board_info;
extern int change_clk(u32 clk, u32 clkss);

extern int change_serial_channel(unsigned int ch);

#endif
#endif
