#include <ep93xx/ioregs.h>
#include <target/io.h>

#include "board.h"

/**
 *  __udelay() : just a temperary implementation.
 **/
#define __udelay()                       \
({                                       \
        __asm__ volatile(                \
                                " nop\n" \
                                " nop\n" \
                                " nop\n" \
                        );               \
})

void udelay(unsigned long usec){
  int i;
  for(i=0; i<usec; i++){
    __udelay();
  }
}

void mdelay(unsigned long msec){
  int i;
  for(i=0; i<msec; i++){
    udelay(1000);
  }
}

