
#include <target/io.h>
#include <target/mem.h>

#include <target/net/eth.h>
#include <target/net/eth_util.h>
#include <target/net/mac.h>
#include <target/net/arp.h>
#include <target/net/ip.h>

const unsigned char broadcast_ipaddr[4] = {0xff, 0xff, 0xff, 0xff};
const unsigned char broadcast_mac[6] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

#if 1
unsigned char eth_ipaddr[4];
unsigned char eth_mac[6];
#endif

hwif_eth rhwif;//registerd hwif

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void enable_phy_module(void){
  rhwif.enable_phy_module();
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void disable_phy_module(void){
  rhwif.disable_phy_module();
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int eth_send(eth_frame *ethfr, const void *pfr, const unsigned int pfrlen){
  safe_memcpy(ethfr->smac, eth_mac, 6);
  return rhwif.eth_send(ethfr, pfr, pfrlen);
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int eth_recv(eth_frame **ethfr, void **pbuf, unsigned int *pbuflen, 
	     int *timeout){
  return rhwif.eth_recv(rhwif.eth_mac, ethfr, pbuf, pbuflen, timeout);
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int eth_rxbuf_free(const int idx){
  return rhwif.eth_rxbuf_free(idx);
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int eth_proc(const int mode, void **pbuf, unsigned int *pbuflen){
  int idx;
  int ret;

  eth_frame *proc_ethfr = 0;
  unsigned char *proc_pbuf = 0;
  unsigned int proc_pbuflen = 0;
  static unsigned char buf[LEN_RxBuf];
  int timeout = 15000;//about 15s

  while(1){
    idx = eth_recv(&proc_ethfr, (void *)&proc_pbuf, &proc_pbuflen, &timeout);
    if(idx == -1){
      return -1;
    }
    safe_memcpy(buf, proc_pbuf, proc_pbuflen);

    if(pbuf != 0){
      *pbuf = buf;
    }
    if(pbuflen != 0){
      *pbuflen = proc_pbuflen;
    }

    eth_rxbuf_free(idx);

    switch(ntohs(proc_ethfr->protocol)){
    case ETH_PROTOCOL_ARP:
      _DEBUG("ARP\n");
      ret = arp_proc(buf, proc_pbuflen);
      if(mode == ARP_WAIT) return 0;
      break;
    case ETH_PROTOCOL_IP:
      _DEBUG("IP\n");
      if(mode == IP_WAIT) return 0;
      break;
    default:
      _DEBUG("Unknown(%d)\n", ntohs(proc_ethfr->protocol));
      break;
    }
  }
  return 0;
}

int register_hwif_eth(hwif_eth *hwif){
  safe_memcpy(&rhwif, hwif, sizeof(hwif_eth));
  safe_memcpy(eth_ipaddr, rhwif.eth_ipaddr, 4);
  safe_memcpy(eth_mac, rhwif.eth_mac, 6);
  return 0;
}
