
#ifndef _HERMIT_IP_H_
#define _HERMIT_IP_H_

#define IP_VERSION 4
#define LEN_IP_Header 20

typedef enum _ip_proc_mode{
  ICMP_WAIT,
  TCP_WAIT,
  UDP_WAIT,
}ip_proc_mode;


typedef struct _ip_frame{
  unsigned char  header_len:4,
                 version:4;
  unsigned char  diffserv;
  unsigned short data_len;
  unsigned short id;
#if 0
  unsigned short flag_offset:13,
                 flag:3;
#else
  unsigned short flag;
#endif
  unsigned char  ttl;//time to live
  unsigned char  protocol;
  unsigned short checksum;
  unsigned char  src_ipaddr[4];
  unsigned char  dst_ipaddr[4];
}ip_frame;

typedef enum _ip_protocol_id{
  IP_PROTOCOL_ICMP = 0x01,
  IP_PROTOCOL_TCP  = 0x06,
  IP_PROTOCOL_UDP  = 0x11,
}ip_protocol_id;


int ip_send(const unsigned char *dst_ipaddr, const unsigned char protocol,
	    const void *pbuf, const unsigned int pbuflen);

int ip_proc(const int mode, void **pbuf, unsigned int *pbuflen);

#endif

