#include <ns9750/ioregs.h>
#include <target/flash.h>
#include <target/io.h>
#include <target/mem.h>
#include <target/str.h>
#include "memregions.h"
#include "board.h"

char target_name[256];
char *target_profile = target_name;

flash_protect flash_protects[] = {
  { FLASH_IPL_START, FLASH_IPL_SIZE },
  { 0, 0 },
};

static inline void _led_control(int mode)
{
  unsigned long v;
  v = IO_EXT_MISC_GCR & ~0x08;
  IO_EXT_MISC_GCR = v | (mode ? 0x08 : 0x00);
}

void led_on(void)
{
  _led_control(1);
}

void led_off(void)
{
  _led_control(0);
}

/**
 *  __udelay() : just a temperary implementation.
 **/
#define __udelay()                       \
({                                       \
        __asm__ volatile(                \
                                " nop\n" \
                                " nop\n" \
                                " nop\n" \
                        );               \
})


void udelay(unsigned long usec){
  int i;
  for(i=0; i<usec; i++){
    __udelay();
  }
}

void mdelay(unsigned long msec){
  int i;
  for(i=0; i<msec; i++){
    udelay(1000);
  }
}

#define BOOTMODE_EXTERNAL	0
#define BOOTMODE_SPI_EEPROM	1

static int check_bootmode(void)
{
  if(IO_SCM_MISC_SYS_CONFIG & 0x00000800){
    /* External-ROM boot mode: reset_done = 1 */
    return BOOTMODE_EXTERNAL;
  }

  /* SPI EEPROM boot mode: reset_done = 0 */
  return BOOTMODE_SPI_EEPROM;
}

static char *get_board_name(int id)
{
  return "Armadillo-300";
}

static void update_target_profile(void)
{
  int len;
  memset(target_name, 0, TARGET_NAME_LEN);
  len = strlen(get_board_name(0));
  strcpy(&target_name[0], get_board_name(0));
  if(strlen(PROFILE_STRING)){
    target_name[len] = '/';
    strcpy(&target_name[len + 1], PROFILE_STRING);
    target_name[len + 1 + strlen(PROFILE_STRING)] = 0; //NULL
  }
}

extern int change_serial_channel(unsigned int ch);

void board_init(void)
{
  int mode = check_bootmode();
  int ch;

  update_target_profile();

  if(strcmp(PROFILE_STRING, "ttyAM1") == 0){
    ch = 2;
  }else if(strcmp(PROFILE_STRING, "notty") == 0){
    ch = 0;
  }else{
    ch = 1;
  }
  change_serial_channel(ch);

  flash_initialize(FLASH_TYPE_AMD, FLASH_START);
  if(mode == BOOTMODE_SPI_EEPROM){
    flash_protects[0].start = 0;
    flash_protects[0].size = 0;
  }
  
  flash_register_protect_table(flash_protects);
}


static int info_cmdfunc(int argc, char *argv[])
{
  hprintf("ipl   : %x\n", *(volatile unsigned long*)0x50000010);

  return 0;
}

const command_t info_command =
        { "info", "", "display board info",
          &info_cmdfunc };
