#include <ns9750/ioregs.h>
#include <target/io.h>
#include <target/mmu.h>
#include "memregions.h"
#include "linux.h"

void boost_on(int mode)
{
  {
    const unsigned int offset = LINUX_LOAD_ADDRESS - 0x4000;
    unsigned int i;
    switch(mode){
    case BOOST_ETH_MODE:
      hprintf("WARNING: BOOST_ETH_MODE not imprimented.\n");
      break;
    case BOOST_LINUX_MODE:
    default:
      for (i = 0x0; i < 0x2000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc1e;
      }
      for (       ; i < 0x4000; i += 0x4) {
	*(volatile unsigned int *)(offset + i) = (i << 18) + 0xc12;
      }
      break;
    }
    
    __asm__ volatile (
            "mov     r0, #0                     \n"
            "mcr     p15, 0, r0, c7, c7, 0      \n"
            "mcr     p15, 0, r0, c8, c7, 0      \n"
            "mov     r0, #0x00024000            \n"
            "mcr     p15, 0, r0, c2, c0         \n"
            "mov     r0, #0xffffffff            \n"
            "mcr     p15, 0, r0, c3, c0         \n"
            "mrc     p15, 0, r0, c1, c0         \n"
            "orr     r0, r0, #0x1000            \n"
            "orr     r0, r0, #0x05              \n"
            "mcr     p15, 0, r0, c1, c0         \n"
            );
  }
}

void boost_off(void)
{
  {
                __asm__ volatile (
                        "1: mrc  p15, 0, r15, c7, c14, 3 \n" /* test,clean,invalidate Dcache */
                        "bne     1b                      \n"
                        "mrc     p15, 0, r0, c1, c0      \n"
                        "bic     r0, r0, #0x1000         \n"
                        "bic     r0, r0, #0x05           \n"
                        "mcr     p15, 0, r0, c1, c0      \n"
                        "mov     r0, #0                  \n"
                        "mcr     p15, 0, r0, c7, c7, 0   \n"
                        "mcr     p15, 0, r0, c8, c7, 0   \n"
                        );
  }
}
