/*
 * boot.S: assembly language bootstrap
 *
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include "memregions.h"

	.section .flash.boot
	.global _start_flash
_start_flash:
	mov	r0, #0x70		/* 32-bit code + data, MMU mandatory */
	mcr	p15, 0, r0, c1, c0, 0	/* MMU init */

	mov	r0, #0
	mcr	p15, 0, r0, c7, c7, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c8, c7, 0	/* flush v4 TLB */

	mov	r0, #0x80000000		/* I/O base */

	mov	r1, #0x100		/* UART enable bit in SYSCON[1|2] */
	str	r1, [r0, #0x100]	/* enable UART1 in SYSCON1 */
	add	r2, r0, #0x1100		/* load address of SYSCON2 in r2 */
	str	r1, [r2]		/* enable UART2 in SYSCON2 */

	mov	r1, #0x00060000		/* UART 8-bit data length */
	orr	r1, r1, #1		/* UART 115200 bps */
	str	r1, [r0, #0x4C0]	/* set UART1 bit rate/line control */
	add	r2, r0, #0x14C0		/* load address of UBRLCR2 in r2 */
	str	r1, [r2]		/* set UART2 bit rate/line control */

	mov	r1, #0x6		/* CLKCTL_73 in SYSCON3 */
	add	r2, r0, #0x2200		/* address of SYSCON3 in r2 */
	str	r1, [r2]		/* set clock speed to 73.728 MHz */

	mov	r1, #0x81		/* 64KHz DRAM refresh period */
	str	r1, [r0, #0x200]	/* set DRFPR */

	mov	r1, #0x500		/* CAS lat = 2, permanent enable, 16 bit wide, 64Mbit SDRAM */
	add	r1, r1, #0x22
	add	r2, r0, #0x2300		/* load address in r2 */
	str	r1, [r2]

	mov	r1, #0x100		/* SDRAM refresh rate */
	add	r2, r0, #0x2340		/* load address in r2 */
	str	r1, [r2]

	mov	sp, #SRAM_START		/* init stack pointer */
	add	sp, sp, #SRAM_SIZE

	bl	entry			/* see entry.c */
1:	b	1b

	.section .ram.boot
	.global _start_ram
_start_ram:
	bl	main
2:	b	2b

