/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_CDB89712_MEMREGIONS_H
#define _HERMIT_CDB89712_MEMREGIONS_H

#define FLASH_BANK1_START	0x00000000
#define FLASH_BANK1_SIZE	0x00800000

#define SRAM_START		0x60000000
#define SRAM_SIZE		0x0000c000

#define BOOTROM_START		0x70000000
#define BOOTROM_SIZE		0x00000080

#define DRAM1_START		0xC0000000
#define DRAM1_SIZE		0x01000000

#ifdef BOOTMODE
#define FLASH_BANK1_MAPPED	0x70000000
#define SRAM_MAPPED		0x10000000
#define BOOTROM_MAPPED		0x00000000
#endif

/*
 * External I/O regions are remapped by boot mode as well.
 */
#ifdef BOOTMODE
#define EXT_CS8900_BASE		0x50000300
#else
#define EXT_CS8900_BASE		0x20000300
#endif

#endif /* _HERMIT_CDB89712_MEMREGIONS_H */

