/*
 * Copyright (C) 2003-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_SUZAKU_MEMREGIONS_8MiB_H
#define _HERMIT_SUZAKU_MEMREGIONS_8MiB_H

#define FLASH_8MiB_ALL_START           (FLASH_START)
#define FLASH_8MiB_ALL_SIZE            (8*8*KiB + 126*64*KiB + 8*8*KiB)
#define FLASH_8MiB_ALL_END             (FLASH_8MiB_ALL_START + FLASH_8MiB_ALL_SIZE - 1)

#define FLASH_8MiB_FREE1_START         (FLASH_START)
#define FLASH_8MiB_FREE1_SIZE          (8*8*KiB)
#define FLASH_8MiB_FREE1_END           (FLASH_8MiB_FREE1_START + FLASH_8MiB_FREE1_SIZE - 1)

#define FLASH_8MiB_FREE2_START         (FLASH_8MiB_FREE1_START + FLASH_8MiB_FREE1_SIZE)
#define FLASH_8MiB_FREE2_SIZE          (7*64*KiB)
#define FLASH_8MiB_FREE2_END           (FLASH_8MiB_FREE2_START + FLASH_8MiB_FREE2_SIZE - 1)

#define FLASH_8MiB_FPGA_START          (FLASH_8MiB_FREE2_START + FLASH_8MiB_FREE2_SIZE)
#define FLASH_8MiB_FPGA_SIZE           (8*64*KiB)
#define FLASH_8MiB_FPGA_END            (FLASH_8MiB_FPGA_START + FLASH_8MiB_FPGA_SIZE - 1)

#define FLASH_8MiB_BOOTLOADER_START    (FLASH_8MiB_FPGA_START + FLASH_8MiB_FPGA_SIZE)
#define FLASH_8MiB_BOOTLOADER_SIZE     (2*64*KiB)
#define FLASH_8MiB_BOOTLOADER_END      (FLASH_8MiB_BOOTLOADER_START + FLASH_8MiB_BOOTLOADER_SIZE - 1)

#define FLASH_8MiB_IMAGE_START         (FLASH_8MiB_BOOTLOADER_START + FLASH_8MiB_BOOTLOADER_SIZE)
#define FLASH_8MiB_IMAGE_SIZE          (109*64*KiB)
#define FLASH_8MiB_IMAGE_END           (FLASH_8MiB_IMAGE_START + FLASH_8MiB_IMAGE_SIZE - 1)

#define FLASH_8MiB_KERNEL_START        (FLASH_8MiB_BOOTLOADER_START + FLASH_8MiB_BOOTLOADER_SIZE)
#define FLASH_8MiB_KERNEL_SIZE         (48*64*KiB)
#define FLASH_8MiB_KERNEL_END          (FLASH_8MiB_KERNEL_START + FLASH_8MiB_KERNEL_SIZE - 1)

#define FLASH_8MiB_USER_START          (FLASH_8MiB_KERNEL_START + FLASH_8MiB_KERNEL_SIZE)
#define FLASH_8MiB_USER_SIZE           (61*64*KiB)
#define FLASH_8MiB_USER_END            (FLASH_8MiB_USER_START + FLASH_8MiB_USER_SIZE - 1)

#define FLASH_8MiB_CONFIG_START        (FLASH_8MiB_IMAGE_START + FLASH_8MiB_IMAGE_SIZE)
#define FLASH_8MiB_CONFIG_SIZE         (8*8*KiB)
#define FLASH_8MiB_CONFIG_END          (FLASH_8MiB_CONFIG_START + FLASH_8MiB_CONFIG_SIZE - 1)

#endif /* _HERMIT_SUZAKU_MEMREGIONS_8MiB_H */
