/*
 * Copyright (c) 2004-2006 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <target/flash.h>
#include <target/frob.h>
#include <target/mem.h>
#include <target/str.h>
#include <target/medium.h>
#include <target/memzero.h>
#include <target/setenv.h>
#include <target/gunzip.h>
#include <target/md5sum.h>
#include <ep93xx/ioregs.h>
#include "linux.h"
#include "memmap.h"
#include "board.h"

#ifdef ENABLE_ETH
#include <target/net/mac.h>
#include "tftpdl.h"
#endif

char target_name[256];
char *target_profile = target_name;

static const command_t *commands[] = {
	&help_command,
	&boot_command,
	&clearenv_command,
	&download_command,
	&flash_erase_command,
	&frob_command,
	&jump_command,
	&linux_command,
	&medium_command,
	&memmap_command,
	&flash_program_command,
	&setenv_command,
	&unzip_command,
	&upload_command,
	&version_command,
	&info_command,
	&md5sum_command,
#ifdef ENABLE_ETH
        &mac_command,
        &tftpdl_command,
#endif
	0
};

ABBR(boot_command, 'b')
ABBR(help_command, '?')
ABBR(frob_command, 'f')
ABBR(version_command, 'V')

static const abbrev_t *abbrevs[] = {
	&boot_command_abbrev,
	&help_command_abbrev,
	&frob_command_abbrev,
	&version_command_abbrev,
	0
};

int hmain(void)
{
	command_list_t command_list = { commands, abbrevs, "hermit", 0 };
	int len;

	flash_initialize(FLASH_TYPE_AMD, FLASH_START);
       	board_init();

	check_mode_jumper();

	switch (board_info.id) {
      	case BOARD_ID_A210:
	  *(unsigned long *)GPIO_PEDDR = 0x03;
	  *(unsigned long *)GPIO_PEDR = 0x02;
	  break;
	case BOARD_ID_A230:
	  /* initialize chip select 7 for the 2nd ethernet
	   * controller. */
	  *(unsigned long *)SMCBCR7 = 0x100085cb; //ICY:15,WST1:14,WST2:32
	  /* FALLTHROUGH */
	case BOARD_ID_A220:
	case BOARD_ID_A240:
	  /* Initialize chip select 3 for NAND Module */
	  *(unsigned long *)SMCBCR3 = 0x00000460;
	  /* Do not fall thorough.  GPIO for 220, 230, and 240 are
	   * initialized in boot.S. Do NOT re-initialize them here. */
	  break;
	case BOARD_ID_A210C:
	  *(unsigned long *)GPIO_PCDDR = 0x80;
	  *(unsigned long *)GPIO_PCDR = 0x80;
	  break;
	default:
	  hprintf("warning: Not matched board type!(%x)\n", board_info.id);
	  break;
	}
#if 0
	update_board_name(get_board_name(id));
#endif
	memzero(target_name, 256);
	len = strlen(get_board_name(board_info.id));
	strcpy(&target_name[0], get_board_name(board_info.id));
	if(strlen(PROFILE_STRING)){
	  target_name[len] = '/';
	  strcpy(&target_name[len + 1], PROFILE_STRING);
	  target_name[len + 1 + strlen(PROFILE_STRING)] = 0; //NULL
	}

	init_crc32();

	/* startup stuff: activate LED and print version string */
	(*version_command.func)(0, 0);

#if defined RELOCATE
	if(jumper_mode == 0){
	  //Linux-Boot
	  (*boot_command.func)(0, 0);
	}
#endif

	switch (board_info.id) {
	case BOARD_ID_A210:
	case BOARD_ID_A210C:
	  LED_RED_OFF();
	  break;
	default:
	  break;
	}
	do_command_loop(&command_list);
	for (;;);
}
