
extern unsigned char __bss_start;
extern unsigned char __bss_end;

#ifdef RELOCATE

/* see loader.lds */
extern unsigned char __text_start_flash;
extern unsigned char __text_start;
extern unsigned char __text_end;
extern unsigned char __data_start_flash;
extern unsigned char __data_start;
extern unsigned char __data_end;

void entry(void)
{
	unsigned char *src, *dst;

	/* relocate .text */
	src = &__text_start_flash;
	dst = &__text_start;
	while (dst < &__text_end)
		*dst++ = *src++;

	/* relocate .data */
	src = &__data_start_flash;
	dst = &__data_start;
	while (dst < &__data_end)
		*dst++ = *src++;

	/* clear .bss */
	dst = &__bss_start; 
	while (dst < &__bss_end)
		*dst++ = 0;

	/* branch into relocated code */
	__asm__ volatile (
	"	mov	r0, #0x00010000\n"	/* start of DRAM */
	"	mov	pc, r0"			/* go there */
	);
}

#else

/* see loader.c */
extern void hmain(void);

void entry(void)
{
	unsigned char *dst;

	/* clear .bss */
	dst = &__bss_start; 
	while (dst < &__bss_end)
		*dst++ = 0;

	hmain();
}

#endif
