/*
 * Copyright (c) 2006 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <ns9750/ioregs.h>
#include <target/flash.h>
#include <target/frob.h>
#include <target/medium.h>
#include "linux.h"
#include "memmap.h"
#include "memregions.h"
#include "board.h"

#include <target/setenv.h>
#include <target/gunzip.h>
#include <target/md5sum.h>

#ifdef ENABLE_ETH
#include <target/net/mac.h>
#include "tftpdl.h"
#endif

static const command_t *commands[] = {
	&help_command,
	&boot_command,
	&clearenv_command,
	&download_command,
	&flash_erase_command,
	&frob_command,
	&jump_command,
	&linux_command,
	&medium_command,
	&memmap_command,
	&flash_program_command,
	&setenv_command,
	&unzip_command,
	&upload_command,
	&version_command,
	&info_command,
	&md5sum_command,
#ifdef ENABLE_ETH
	&mac_command,
	&tftpdl_command,
#endif
#if defined(EXPERIMENTAL)
	&region_command,
#endif
	0
};

ABBR(boot_command, 'b')
ABBR(help_command, '?')
ABBR(frob_command, 'f')
ABBR(version_command, 'V')

static const abbrev_t *abbrevs[] = {
	&boot_command_abbrev,
	&help_command_abbrev,
	&frob_command_abbrev,
	&version_command_abbrev,
	0
};

int hmain(void)
{
	command_list_t command_list = { commands, abbrevs, "hermit", 0 };

	board_init();

	init_crc32();
	
	/* startup stuff: activate LED and print version string */
	(*version_command.func)(0, 0);

#if defined RELOCATE
	(*boot_command.func)(0, 0);
#endif

	if(strcmp(PROFILE_STRING, "notty") == 0){
	  change_serial_channel(1);
	}
	
	led_off();

	do_command_loop(&command_list);
	for (;;);
}
