#include <target/herrno.h>
#include <target/htypes.h>
#include <target/str.h>
#include "memregions.h"
#include <target/param.h>

#if defined(HAVE_IDE)
#define IDE_DEVICE_STR "/hda[1:4]"
#else
#define IDE_DEVICE_STR ""
#endif

static int 
setbootdevice_cmdfunc(int argc, char **argv)
{
	/* initialize parameter: bootdevice, using default flash */
	if (!check_param("@bootdevice")) {
		char *c_argv[2] = {argv[0], "flash"};
		sethermit_param(2, c_argv, "@bootdevice");
	}

	if (argc > 1)
		if (strcmp(argv[1], "flash") != 0
#if defined(HAVE_IDE)
		    && strcmp(argv[1], "hda1") != 0
		    && strcmp(argv[1], "hda2") != 0
		    && strcmp(argv[1], "hda3") != 0
		    && strcmp(argv[1], "hda4") != 0
		    && strcmp(argv[1], "hda") != 0
#endif
			)
			return -H_EINVAL;

	return sethermit_param(argc, argv, "@bootdevice");
}

const command_t setbootdevice_command =
	{ "setbootdevice", "<flash" IDE_DEVICE_STR ">",
	  "linux kernel location", &setbootdevice_cmdfunc };

COMMAND_ABBR(setbootdevice_command, 'l');
