#include <target/herrno.h>
#include <target/htypes.h>
#include <target/str.h>
#include "memregions.h"
#include <target/param.h>

static int 
setclock_cmdfunc(int argc, char *argv[])
{
	/* initialize parameter: clock, using default 400 */
	if (!check_param("@clock")) {
		char *c_argv[2] = {argv[0], "400"};
		sethermit_param(2, c_argv, "@clock");
	}

	if (argc > 1)
		if (strcmp(argv[1], "532") != 0 &&
		    strcmp(argv[1], "400") != 0)
			return -H_EINVAL;

	return sethermit_param(argc, argv, "@clock");
}

const command_t setclock_command =
	{"setclock", "<400/532>", "set mcu_clk", &setclock_cmdfunc};

COMMAND(setclock_command);
